/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.recycleradapter;

import android.view.View;
import com.github.nukc.recycleradapter.RecyclerHolder;
import java.lang.reflect.Constructor;

class HolderHelper {
    HolderHelper() {
    }

    static <VH extends RecyclerHolder> VH newInstance(Class<?> holderClass, View view, Object listener) {
        Constructor<?>[] constructors = holderClass.getDeclaredConstructors();
        if (constructors == null) {
            throw new IllegalArgumentException("Impossible to found a constructor for " + holderClass.getSimpleName());
        }
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes == null || listener != null && parameterTypes.length == 1) continue;
            try {
                Object viewHolder = null;
                if (HolderHelper.isAssignableFrom(parameterTypes, View.class)) {
                    constructor.setAccessible(true);
                    viewHolder = constructor.newInstance(view);
                } else if (HolderHelper.isAssignableFrom(parameterTypes, View.class, Object.class)) {
                    constructor.setAccessible(true);
                    viewHolder = constructor.newInstance(view, listener);
                }
                if (!(viewHolder instanceof RecyclerHolder)) continue;
                return (VH)((Object)((RecyclerHolder)viewHolder));
            }
            catch (Exception e) {
                throw new RuntimeException("Impossible to instantiate " + holderClass.getSimpleName(), e);
            }
        }
        throw new IllegalArgumentException("Impossible to found a constructor with a view for " + holderClass.getSimpleName());
    }

    private static boolean isAssignableFrom(Class<?>[] parameterTypes, Class<?> ... classes) {
        if (parameterTypes == null || classes == null || parameterTypes.length != classes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (classes[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

