/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class TestFixture {
    public String trace_separator = "";
    public Class<?> bottom_class = this.getClass();

    public void trim_stack_trace(Throwable t, int peel) {
        StackTraceElement[] trace = t.getStackTrace();
        int new_end = trace.length;
        for (int i = trace.length - 1; i >= 0; --i) {
            if (!trace[i].getClassName().equals(this.bottom_class.getName())) continue;
            new_end = i + 1;
            break;
        }
        t.setStackTrace(Arrays.copyOfRange(trace, peel, new_end));
    }

    public void throw_assertion(int peel, String msg) {
        AssertionError error = new AssertionError((Object)(msg + this.trace_separator));
        this.trim_stack_trace((Throwable)((Object)error), peel + 1);
        throw error;
    }

    public void assert_true(boolean condition, int peel, Supplier<String> msg) {
        if (!condition) {
            this.throw_assertion(peel + 1, msg.get());
        }
    }

    public void assert_true(boolean condition, Supplier<String> msg) {
        if (!condition) {
            this.throw_assertion(1, msg.get());
        }
    }

    public void assert_true(boolean condition, String msg) {
        if (!condition) {
            this.throw_assertion(1, msg);
        }
    }

    public void assert_true(boolean condition) {
        if (!condition) {
            this.throw_assertion(1, "");
        }
    }

    public void assert_equals(Object actual, Object expected, int peel, Supplier<String> msg) {
        if (!Objects.deepEquals(actual, expected)) {
            this.throw_assertion(peel + 1, msg.get() + "\nexpected [" + expected + "] but found [" + actual + "]");
        }
    }

    public void assert_equals(Object actual, Object expected, Supplier<String> msg) {
        this.assert_equals(actual, expected, 1, msg);
    }

    public void assert_equals(Object actual, Object expected, String msg) {
        this.assert_equals(actual, expected, 1, () -> msg);
    }

    public void assert_equals(Object actual, Object expected) {
        this.assert_equals(actual, expected, 1, () -> "");
    }

    public void assert_not_equals(Object actual, Object expected, int peel, Supplier<String> msg) {
        if (Objects.deepEquals(actual, expected)) {
            this.throw_assertion(peel + 1, msg.get() + "\nexpected not same [" + expected + "] but found [" + actual + "]");
        }
    }

    public void assert_not_equals(Object actual, Object expected, Supplier<String> msg) {
        this.assert_not_equals(actual, expected, 1, msg);
    }

    public void assert_not_equals(Object actual, Object expected, String msg) {
        this.assert_not_equals(actual, expected, 1, () -> msg);
    }

    public void assert_not_equals(Object actual, Object expected) {
        this.assert_not_equals(actual, expected, 1, () -> "");
    }

    public void assert_same(Object actual, Object expected, int peel, Supplier<String> msg) {
        if (actual != expected) {
            this.throw_assertion(peel + 1, msg.get() + "\nexpected [" + expected + "] but found [" + actual + "]");
        }
    }

    public void assert_same(Object actual, Object expected, Supplier<String> msg) {
        this.assert_same(actual, expected, 1, msg);
    }

    public void assert_same(Object actual, Object expected, String msg) {
        this.assert_same(actual, expected, 1, () -> msg);
    }

    public void assert_same(Object actual, Object expected) {
        this.assert_same(actual, expected, 1, () -> "");
    }

    public void assert_not_same(Object actual, Object expected, int peel, Supplier<String> msg) {
        if (actual == expected) {
            this.throw_assertion(peel + 1, msg.get() + "\nexpected not same [" + expected + "] but found [" + actual + "]");
        }
    }

    public void assert_not_same(Object actual, Object expected, Supplier<String> msg) {
        this.assert_not_same(actual, expected, 1, msg);
    }

    public void assert_not_same(Object actual, Object expected, String msg) {
        this.assert_not_same(actual, expected, 1, () -> msg);
    }

    public void assert_not_same(Object actual, Object expected) {
        this.assert_not_same(actual, expected, 1, () -> "");
    }
}

