/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.ArrayList;
import java.util.NoSuchElementException;

public final class Strings {
    public static char last_char(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("empty string");
        }
        return string.charAt(string.length() - 1);
    }

    public static String repeat(char c, int n) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = c;
        }
        return new String(chars);
    }

    public static String[] lines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            lines.add(string.substring(start, i));
            start = i + 1;
        }
        lines.add(string.substring(start));
        return lines.toArray(new String[0]);
    }

    public static String indent(String string, String prefix) {
        String[] lines = Strings.lines(string);
        StringBuilder b = new StringBuilder();
        for (String line : lines) {
            Strings.append(b, prefix, line, "\n");
        }
        Strings.pop(b, 1);
        return b.toString();
    }

    public static String indent_except_first(String string, String prefix) {
        String[] lines = Strings.lines(string);
        StringBuilder b = new StringBuilder();
        Strings.append(b, lines[0], "\n");
        for (int i = 1; i < lines.length; ++i) {
            Strings.append(b, prefix, lines[i], "\n");
        }
        Strings.pop(b, 1);
        return b.toString();
    }

    public static void append(StringBuilder b, String ... strings) {
        for (String string : strings) {
            b.append(string);
        }
    }

    public static void pop(StringBuilder b, int n) {
        if (b.length() < n) {
            throw new NoSuchElementException();
        }
        b.replace(b.length() - n, b.length(), "");
    }

    public static <T> void separated(StringBuilder b, String sep, T ... items) {
        int length = b.length();
        for (T item : items) {
            b.append(item).append(sep);
        }
        if (b.length() > length) {
            Strings.pop(b, sep.length());
        }
    }

    public static String human_friendly_byte_count(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

