/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public final class NArrays {
    public static <T, R> R[] map(T[] array, R[] witness, Function<T, R> f) {
        R[] out = Arrays.copyOf(witness, array.length);
        for (int i = 0; i < array.length; ++i) {
            out[i] = f.apply(array[i]);
        }
        return out;
    }

    public static <T> T[] resize_binary_power(T[] array, int min_size) {
        int size;
        for (size = 1; size < min_size; size <<= 1) {
        }
        return Arrays.copyOf(array, size);
    }

    public static int[] resize_binary_power(int[] array, int min_size) {
        int size;
        for (size = 1; size < min_size; size <<= 1) {
        }
        return Arrays.copyOf(array, size);
    }

    public static long[] resize_binary_power(long[] array, int min_size) {
        int size;
        for (size = 1; size < min_size; size <<= 1) {
        }
        return Arrays.copyOf(array, size);
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }

    public static <T> int pack(T[] array) {
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i++] == null) continue;
            array[j++] = array[i - 1];
        }
        return j;
    }

    public static <T> T[] pack_ret(T[] array) {
        NArrays.pack(array);
        return array;
    }

    public static <T> T[] packed(T[] array) {
        Object[] copy = (Object[])array.clone();
        int len = NArrays.pack(copy);
        return Arrays.copyOf(copy, len);
    }

    public static <T> int index_of(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T item) {
        return NArrays.index_of(array, item) >= 0;
    }

    public static <T> T[] append(T[] array, T ... items) {
        T[] copy = Arrays.copyOf(array, array.length + items.length);
        System.arraycopy(items, 0, copy, array.length, items.length);
        return copy;
    }
}

