/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.function.Function;
import norswap.utils.NoStackException;

public final class Exceptional<T> {
    private final T value;
    private final RuntimeException exception;

    private Exceptional(T value, RuntimeException exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <T> Exceptional<T> value(T value) {
        return new Exceptional<T>(value, null);
    }

    public static <T> Exceptional<T> exception(Throwable throwable) {
        return new Exceptional<Object>(null, new NoStackException(throwable));
    }

    public static <T> Exceptional<T> exception(RuntimeException exception) {
        return new Exceptional<Object>(null, exception);
    }

    public static <T> Exceptional<T> error(String message) {
        return new Exceptional<Object>(null, new NoStackException(message));
    }

    public T get() {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public T nullable() {
        return this.exception == null ? (T)this.value : null;
    }

    public Object unwrap() {
        return this.exception == null ? this.value : this.exception;
    }

    public RuntimeException exception() {
        return this.exception;
    }

    public boolean is_value() {
        return this.exception == null;
    }

    public boolean is_exception() {
        return this.exception != null;
    }

    public <R> Exceptional<R> map(Function<T, R> f) {
        return this.exception == null ? Exceptional.value(f.apply(this.value)) : Exceptional.exception(this.exception);
    }

    public <R> Exceptional<R> flatmap(Function<T, Exceptional<R>> f) {
        return this.exception == null ? f.apply(this.value) : Exceptional.exception(this.exception);
    }

    public String message() {
        return this.exception == null ? "success" : this.exception.getMessage();
    }
}

