/*
 * Decompiled with CFR 0.152.
 */
package com.github.noraui.application.steps.themes.meterial;

import com.github.noraui.application.page.Page;
import com.github.noraui.application.steps.Step;
import com.github.noraui.browser.waits.Wait;
import com.github.noraui.cucumber.annotation.Conditioned;
import com.github.noraui.exception.FailureException;
import com.github.noraui.exception.Result;
import com.github.noraui.exception.TechnicalException;
import com.github.noraui.gherkin.GherkinStepCondition;
import com.github.noraui.log.annotation.Loggable;
import com.github.noraui.utils.Context;
import com.github.noraui.utils.Messages;
import com.github.noraui.utils.Utilities;
import io.cucumber.java.en.Then;
import io.cucumber.java.fr.Lorsque;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.slf4j.Logger;

@Loggable
public class MaterialSteps
extends Step {
    static Logger log;

    @Conditioned
    @Lorsque(value="Je mets \u00e0 jour le mat-slide-toggle {page-element} avec {string}(\\?)")
    @Then(value="I update mat-slide-toggle {page-element} with {string}(\\?)")
    public void selectCheckbox(Page.PageElement pageElement, String value, List<GherkinStepCondition> conditions) throws TechnicalException, FailureException {
        this.selectMatSlideToggle(pageElement, Boolean.parseBoolean(value), new Object[0]);
    }

    @Conditioned
    @Lorsque(value="Je mets \u00e0 jour le mat-radio-button {page-element} avec {string}(\\?)")
    @Then(value="I update mat-radio-button {page-element} with {string}(\\?)")
    public void updateRadioList(Page.PageElement pageElement, String valueOrKey, List<GherkinStepCondition> conditions) throws TechnicalException, FailureException {
        this.updateMatRadioButton(pageElement, valueOrKey);
    }

    protected void selectMatSlideToggle(Page.PageElement element, boolean checked, Object ... args) throws TechnicalException, FailureException {
        try {
            WebElement webElement = (WebElement)Wait.until((ExpectedCondition)ExpectedConditions.elementToBeClickable((By)Utilities.getLocator((Page.PageElement)element, (Object[])args)));
            if ("false".equals(webElement.getAttribute("ng-reflect-checked")) && checked || "true".equals(webElement.getAttribute("ng-reflect-checked")) && !checked) {
                webElement.click();
            }
        }
        catch (Exception e) {
            new Result.Failure((Object)e.getMessage(), Messages.format((String)Messages.getMessage((String)"FAIL_MESSAGE_MATERIAL_UNABLE_TO_CHECK_ELEMENT"), (Object[])new Object[]{element, element.getPage().getApplication()}), true, element.getPage().getCallBack());
        }
    }

    protected void updateMatRadioButton(Page.PageElement pageElement, String valueOrKey) throws TechnicalException, FailureException {
        String value = Context.getValue((String)valueOrKey) != null ? Context.getValue((String)valueOrKey) : valueOrKey;
        try {
            List radioButtons = (List)Wait.until((ExpectedCondition)ExpectedConditions.presenceOfAllElementsLocatedBy((By)Utilities.getLocator((Page.PageElement)pageElement, (Object[])new Object[0])));
            for (WebElement button : radioButtons) {
                if (!button.getAttribute("value").equals(value)) continue;
                button.click();
                break;
            }
        }
        catch (Exception e) {
            new Result.Failure((Object)e.getMessage(), Messages.format((String)Messages.getMessage((String)"FAIL_MESSAGE_MATERIAL_UNABLE_TO_SELECT_RADIO_BUTTON"), (Object[])new Object[]{pageElement}), true, pageElement.getPage().getCallBack());
        }
    }
}

