/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.math;

import com.github.noonmaru.math.Vector;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public final class VectorSpace
implements Iterable<Vector> {
    private final ArrayList<Vector> vectors;
    private SoftReference<VectorSpace> temp;
    private List<Vector> unmodifiableVectors;

    public VectorSpace(Collection<Vector> c) {
        this.vectors = new ArrayList<Vector>(c);
    }

    public VectorSpace(Vector ... vectors) {
        this(Arrays.asList(vectors));
    }

    public VectorSpace(int initCapacity) {
        this.vectors = new ArrayList(initCapacity);
    }

    private VectorSpace(VectorSpace vectorSpace) {
        this.vectors = new ArrayList(vectorSpace.vectors.size());
        for (Vector vector : vectorSpace) {
            this.vectors.add(vector.copy());
        }
    }

    public void addVector(Vector vector) {
        this.vectors.add(vector);
        this.clearTemp();
    }

    public boolean removeVector(Vector vector) {
        if (this.vectors.remove(vector)) {
            this.clearTemp();
            return true;
        }
        return false;
    }

    public boolean removeVectorIf(Predicate<Vector> filter) {
        if (this.vectors.removeIf(filter)) {
            this.clearTemp();
            return true;
        }
        return false;
    }

    public void trimToSize() {
        this.vectors.trimToSize();
    }

    public VectorSpace add(double x, double y, double z) {
        for (Vector vector : this.vectors) {
            vector.add(x, y, z);
        }
        return this;
    }

    public VectorSpace add(double v) {
        return this.add(v, v, v);
    }

    public VectorSpace add(Vector v) {
        return this.add(v.x, v.y, v.z);
    }

    public VectorSpace subtract(double x, double y, double z) {
        for (Vector vector : this.vectors) {
            vector.subtract(x, y, z);
        }
        return this;
    }

    public VectorSpace subtract(double v) {
        return this.subtract(v, v, v);
    }

    public VectorSpace subtract(Vector v) {
        return this.subtract(v.x, v.y, v.z);
    }

    public VectorSpace multiply(double x, double y, double z) {
        for (Vector vector : this.vectors) {
            vector.multiply(x, y, z);
        }
        return this;
    }

    public VectorSpace multiply(double v) {
        return this.multiply(v, v, v);
    }

    public VectorSpace multiply(Vector v) {
        return this.multiply(v.x, v.y, v.z);
    }

    public VectorSpace devide(double x, double y, double z) {
        for (Vector vector : this.vectors) {
            vector.x /= x;
            vector.y /= y;
            vector.z /= z;
        }
        return this;
    }

    public VectorSpace devide(double v) {
        return this.devide(v, v, v);
    }

    public VectorSpace devide(Vector v) {
        return this.devide(v.x, v.y, v.z);
    }

    public VectorSpace rotateAxisX(double pitch) {
        Vector.rotateAxisX(this.vectors, pitch);
        return this;
    }

    public VectorSpace rotateAxisY(double yaw) {
        Vector.rotateAxisY(this.vectors, yaw);
        return this;
    }

    public VectorSpace rotateAxisZ(double roll) {
        Vector.rotateAxisZ(this.vectors, roll);
        return this;
    }

    @Override
    public Iterator<Vector> iterator() {
        return this.vectors.iterator();
    }

    public VectorSpace temp() {
        VectorSpace mirror;
        VectorSpace vectorSpace = mirror = this.temp == null ? null : this.temp.get();
        if (mirror == null) {
            mirror = new VectorSpace(this);
            this.temp = new SoftReference<VectorSpace>(mirror);
        } else {
            ArrayList<Vector> src = this.vectors;
            ArrayList<Vector> dst = mirror.vectors;
            int size = src.size();
            for (int i = 0; i < size; ++i) {
                dst.get(i).set(src.get(i));
            }
        }
        return mirror;
    }

    public void clearTemp() {
        this.temp = null;
    }

    public List<Vector> getVectors() {
        List<Vector> vectors = this.unmodifiableVectors;
        return vectors == null ? (this.unmodifiableVectors = Collections.unmodifiableList(this.vectors)) : vectors;
    }

    public int size() {
        return this.vectors.size();
    }

    public VectorSpace copy() {
        return new VectorSpace(this);
    }
}

