/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.math;

import com.github.noonmaru.math.Vector;
import com.github.noonmaru.math.VectorSpace;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLabel;

public final class VectorParser {
    private static JLabel jLabel;

    public static VectorSpace parseImage(BufferedImage image, double pixelSize) {
        int width = image.getWidth();
        int height = image.getHeight();
        double halfWidth = (double)(width - 1) / 2.0;
        double halfHeight = (double)(height - 1) / 2.0;
        ArrayList<Vector> vectors = new ArrayList<Vector>(width * height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int dot = image.getRGB(x, y);
                if (dot == 0 || dot == -1) continue;
                vectors.add(new Vector(-((double)x - halfWidth) * pixelSize, -((double)y - halfHeight) * pixelSize, 0.0));
            }
        }
        vectors.trimToSize();
        return new VectorSpace(vectors);
    }

    public static VectorSpace parseText(String s, String fontName, int fontStyle, int fontSize, double pixelSize) {
        return VectorParser.parseText(s, new Font(fontName, fontStyle, fontSize), pixelSize);
    }

    private static FontMetrics getFontMetrics(Font font) {
        if (jLabel == null) {
            jLabel = new JLabel();
        }
        return jLabel.getFontMetrics(font);
    }

    public static VectorSpace parseText(String s, Font font, double pixelSize) {
        FontMetrics metrics = VectorParser.getFontMetrics(font);
        int width = metrics.stringWidth(s);
        int height = metrics.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphic = image.createGraphics();
        graphic.setFont(font);
        graphic.setColor(Color.BLACK);
        graphic.drawString(s, 0, metrics.getMaxAscent());
        graphic.dispose();
        return VectorParser.parseImage(image, pixelSize);
    }

    private VectorParser() {
    }
}

