/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.math;

import com.github.noonmaru.math.MathHelper;

public final class Vector {
    public double x;
    public double y;
    public double z;

    public static void rotateAxisX(Iterable<Vector> vectors, double pitch) {
        double radians = MathHelper.toRadians(pitch);
        double cos = MathHelper.cos(radians);
        double sin = MathHelper.sin(radians);
        for (Vector vector : vectors) {
            vector.rotateAxisX(cos, sin);
        }
    }

    public static void rotateAxisY(Iterable<Vector> vectors, double yaw) {
        double radians = MathHelper.toRadians(yaw);
        double cos = MathHelper.cos(radians);
        double sin = MathHelper.sin(radians);
        for (Vector vector : vectors) {
            vector.rotateAxisY(cos, sin);
        }
    }

    public static void rotateAxisZ(Iterable<Vector> vectors, double roll) {
        double radians = MathHelper.toRadians(roll);
        double cos = MathHelper.cos(radians);
        double sin = MathHelper.sin(radians);
        for (Vector vector : vectors) {
            vector.rotateAxisZ(cos, sin);
        }
    }

    public Vector() {
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector set(Vector p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        return this;
    }

    public Vector add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector add(Vector p) {
        return this.add(p.x, p.y, p.z);
    }

    public Vector subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector subtract(Vector p) {
        return this.subtract(p.x, p.y, p.z);
    }

    public Vector multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    public Vector multiply(Vector p) {
        return this.multiply(p.x, p.y, p.z);
    }

    public Vector devide(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector devide(double d) {
        return this.devide(d, d, d);
    }

    public Vector devide(Vector p) {
        return this.devide(p.x, p.y, p.z);
    }

    public Vector rotateAxisX(double pitch) {
        double radians = MathHelper.toRadians(pitch);
        this.rotateAxisX(MathHelper.cos(radians), MathHelper.sin(radians));
        return this;
    }

    private void rotateAxisX(double cos, double sin) {
        double y = this.y;
        double z = this.z;
        this.y = y * cos - z * sin;
        this.z = z * cos + y * sin;
    }

    public Vector rotateAxisY(double yaw) {
        double radians = MathHelper.toRadians(yaw);
        this.rotateAxisY(MathHelper.cos(radians), MathHelper.sin(radians));
        return this;
    }

    private void rotateAxisY(double cos, double sin) {
        double x = this.x;
        double z = this.z;
        this.x = x * cos - z * sin;
        this.z = z * cos + x * sin;
    }

    public Vector rotateAxisZ(double roll) {
        double radians = MathHelper.toRadians(roll);
        this.rotateAxisZ(MathHelper.cos(radians), MathHelper.sin(radians));
        return this;
    }

    private void rotateAxisZ(double cos, double sin) {
        double x = this.x;
        double y = this.y;
        this.x = x * cos - y * sin;
        this.y = y * cos + x * sin;
    }

    public Vector zero() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        return this;
    }

    public Vector random() {
        this.x = Math.random();
        this.y = Math.random();
        this.z = Math.random();
        return this;
    }

    public Vector normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public double lengthSquared() {
        return MathHelper.square(this.x) + MathHelper.square(this.y) + MathHelper.square(this.z);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distanceSquared(double x, double y, double z) {
        return MathHelper.square(x - this.x) + MathHelper.square(y - this.y) + MathHelper.square(z - this.z);
    }

    public double distanceSquared(Vector p) {
        return this.distanceSquared(p.x, p.y, p.z);
    }

    public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public double distance(Vector p) {
        return this.distance(p.x, p.y, p.z);
    }

    public Vector copy() {
        return new Vector(this.x, this.y, this.z);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector) {
            Vector other = (Vector)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public String toString() {
        return "vector[" + this.x + ", " + this.y + ", " + this.z + ']';
    }
}

