/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.collections.mut;

import com.github.noonmaru.collections.Node;
import com.github.noonmaru.collections.NodeCollection;
import com.github.noonmaru.collections.NodeDeque;
import com.github.noonmaru.collections.NodeList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public class LinkedNodeList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
NodeCollection<E>,
NodeList<E>,
NodeDeque<E>,
Cloneable,
Serializable {
    transient int size = 0;
    transient NodeImpl<E> first;
    transient NodeImpl<E> last;

    public LinkedNodeList() {
    }

    public LinkedNodeList(Collection<? extends E> c) {
        this.addAll(c);
    }

    NodeImpl<E> linkFirst(E e) {
        NodeImpl<E> f = this.first;
        NodeImpl<E> newNode = new NodeImpl<E>(this, null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
        ++this.modCount;
        return newNode;
    }

    NodeImpl<E> linkLast(E e) {
        NodeImpl<E> l = this.last;
        NodeImpl<E> newNode = new NodeImpl<E>(this, l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        ++this.modCount;
        return newNode;
    }

    NodeImpl<E> linkBefore(E e, NodeImpl<E> node) {
        NodeImpl prev = node.prev;
        NodeImpl newNode = new NodeImpl(this, prev, e, node);
        node.prev = newNode;
        if (prev == null) {
            this.first = newNode;
        } else {
            prev.next = newNode;
        }
        ++this.size;
        ++this.modCount;
        return newNode;
    }

    NodeImpl<E> linkAfter(E e, NodeImpl<E> node) {
        NodeImpl next = node.next;
        NodeImpl<E> newNode = new NodeImpl<E>(this, node, e, next);
        node.next = newNode;
        if (next == null) {
            this.last = newNode;
        } else {
            next.prev = newNode;
        }
        ++this.size;
        ++this.modCount;
        return newNode;
    }

    E unlinkFirst(NodeImpl<E> f) {
        Object element = f.item;
        NodeImpl next = f.next;
        f.list = null;
        f.item = null;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.size;
        ++this.modCount;
        return element;
    }

    E unlinkLast(NodeImpl<E> l) {
        Object element = l.item;
        NodeImpl prev = l.prev;
        l.list = null;
        l.item = null;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.size;
        ++this.modCount;
        return element;
    }

    E unlink(NodeImpl<E> x) {
        Object element = x.item;
        NodeImpl next = x.next;
        NodeImpl prev = x.prev;
        x.list = null;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
        }
        --this.size;
        ++this.modCount;
        return element;
    }

    @Override
    public E getFirst() {
        NodeImpl<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return f.item;
    }

    @Override
    public E getLast() {
        NodeImpl<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return l.item;
    }

    @Override
    public E removeFirst() {
        NodeImpl<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(f);
    }

    @Override
    public E removeLast() {
        NodeImpl<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(l);
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        NodeImpl<Object> prev;
        NodeImpl<E> succ;
        this.checkPositionIndex(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        if (index == this.size) {
            succ = null;
            prev = this.last;
        } else {
            succ = this.node(index);
            prev = succ.prev;
        }
        Object[] objectArray = a;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object o;
            Object e = o = objectArray[i];
            NodeImpl<Object> newNode = new NodeImpl<Object>(this, prev, e, null);
            if (prev == null) {
                this.first = newNode;
            } else {
                prev.next = newNode;
            }
            prev = newNode;
        }
        if (succ == null) {
            this.last = prev;
        } else {
            prev.next = succ;
            succ.prev = prev;
        }
        this.size += numNew;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        NodeImpl<E> x = this.first;
        while (x != null) {
            NodeImpl next = x.next;
            x.list = null;
            x.item = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int index) {
        this.checkElementIndex(index);
        return this.node((int)index).item;
    }

    @Override
    public E set(int index, E element) {
        this.checkElementIndex(index);
        NodeImpl<E> x = this.node(index);
        Object oldVal = x.item;
        x.item = element;
        return oldVal;
    }

    @Override
    public void add(int index, E element) {
        this.checkPositionIndex(index);
        if (index == this.size) {
            this.linkLast(element);
        } else {
            this.linkBefore(element, this.node(index));
        }
    }

    @Override
    public E remove(int index) {
        this.checkElementIndex(index);
        return this.unlink(this.node(index));
    }

    private boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    private boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    NodeImpl<E> node(int index) {
        if (index < this.size >> 1) {
            NodeImpl<E> x = this.first;
            for (int i = 0; i < index; ++i) {
                x = x.next;
            }
            return x;
        }
        NodeImpl<E> x = this.last;
        for (int i = this.size - 1; i > index; --i) {
            x = x.prev;
        }
        return x;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        } else {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            NodeImpl<E> x = this.last;
            while (x != null) {
                --index;
                if (x.item == null) {
                    return index;
                }
                x = x.prev;
            }
        } else {
            NodeImpl<E> x = this.last;
            while (x != null) {
                --index;
                if (o.equals(x.item)) {
                    return index;
                }
                x = x.prev;
            }
        }
        return -1;
    }

    @Override
    public E peek() {
        NodeImpl<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E poll() {
        NodeImpl<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        NodeImpl<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    public E peekLast() {
        NodeImpl<E> l = this.last;
        return l == null ? null : (E)l.item;
    }

    @Override
    public E pollFirst() {
        NodeImpl<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    public E pollLast() {
        NodeImpl<E> l = this.last;
        return l == null ? null : (E)this.unlinkLast(l);
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            NodeImpl<E> x = this.last;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        } else {
            NodeImpl<E> x = this.last;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        }
        return false;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.checkPositionIndex(index);
        return new ListItr(index);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public Node<E> getNode(Object o) {
        if (o == null) {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    return x;
                }
                x = x.next;
            }
        } else {
            NodeImpl<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    return x;
                }
                x = x.next;
            }
        }
        return null;
    }

    @Override
    public Node<E> getNode(int index) {
        this.checkElementIndex(index);
        return this.node(index);
    }

    @Override
    public Node<E> addNode(E e) {
        return this.linkLast(e);
    }

    @Override
    public Node<E> addNode(int index, E e) {
        this.checkPositionIndex(index);
        if (index == this.size) {
            return this.linkLast(e);
        }
        return this.linkBefore(e, this.node(index));
    }

    @Override
    public Node<E> addFirstNode(E e) {
        return this.linkFirst(e);
    }

    @Override
    public Node<E> addLastNode(E e) {
        return this.linkLast(e);
    }

    @Override
    public Node<E> offerNode(E e) {
        return this.linkLast(e);
    }

    @Override
    public Node<E> offerFirstNode(E e) {
        return this.linkFirst(e);
    }

    @Override
    public Node<E> offerLastNode(E e) {
        return this.linkLast(e);
    }

    @Override
    public Node<E> getFirstNode() {
        NodeImpl<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return f;
    }

    @Override
    public Node<E> getLastNode() {
        NodeImpl<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return l;
    }

    @Override
    public Node<E> peekNode() {
        return this.first;
    }

    @Override
    public Node<E> peekFirstNode() {
        return this.first;
    }

    @Override
    public Node<E> peekLastNode() {
        return this.last;
    }

    private LinkedNodeList<E> superClone() {
        try {
            return (LinkedNodeList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public Object clone() {
        LinkedNodeList clone = this.superClone();
        clone.last = null;
        clone.first = null;
        clone.size = 0;
        clone.modCount = 0;
        NodeImpl<E> x = this.first;
        while (x != null) {
            clone.add(x.item);
            x = x.next;
        }
        return clone;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        NodeImpl<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        T[] result = a;
        NodeImpl<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        NodeImpl<E> x = this.first;
        while (x != null) {
            s.writeObject(x.item);
            x = x.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.linkLast(s.readObject());
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new LLSpliterator(this, -1, 0);
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedNodeList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private NodeImpl<E> lastReturned;
        private NodeImpl<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedNodeList.this.modCount;
            this.next = index == LinkedNodeList.this.size ? null : LinkedNodeList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedNodeList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedNodeList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            NodeImpl lastNext = this.lastReturned.next;
            LinkedNodeList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedNodeList.this.linkLast(e);
            } else {
                LinkedNodeList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedNodeList.this.modCount == this.expectedModCount && this.nextIndex < LinkedNodeList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedNodeList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class NodeImpl<E>
    implements Node<E> {
        LinkedNodeList<E> list;
        NodeImpl<E> prev;
        NodeImpl<E> next;
        E item;

        NodeImpl(LinkedNodeList<E> list, NodeImpl<E> prev, E item, NodeImpl<E> next) {
            this.list = list;
            this.prev = prev;
            this.next = next;
            this.item = item;
        }

        @Override
        public NodeImpl<E> previous() {
            if (this.list != null) {
                return this.prev;
            }
            NodeImpl<E> p = this.prev;
            if (p != null) {
                this.item = null;
                this.next = null;
                this.prev = null;
                if (p != null && p.list == null) {
                    while ((p = p.prev) != null && p.list == null) {
                    }
                }
            }
            return p;
        }

        @Override
        public NodeImpl<E> next() {
            if (this.list != null) {
                return this.next;
            }
            NodeImpl<E> n = this.next;
            this.item = null;
            this.next = null;
            this.prev = null;
            if (n != null && n.list == null) {
                while ((n = n.next) != null && n.list == null) {
                }
            }
            return n;
        }

        @Override
        public NodeImpl<E> linkBefore(E item) {
            LinkedNodeList<E> list = this.list;
            if (list == null) {
                throw new IllegalArgumentException("Unlinked node");
            }
            return list.linkBefore(item, this);
        }

        @Override
        public NodeImpl<E> linkAfter(E item) {
            LinkedNodeList<E> list = this.list;
            if (list == null) {
                throw new IllegalArgumentException("Unlinked node");
            }
            return list.linkAfter(item, this);
        }

        @Override
        public E getItem() {
            return this.item;
        }

        @Override
        public E setItem(E item) {
            E oldItem = this.item;
            this.item = item;
            return oldItem;
        }

        @Override
        public boolean isLinked() {
            return this.list != null;
        }

        @Override
        public boolean unlink() {
            LinkedNodeList<E> list = this.list;
            if (list == null) {
                return false;
            }
            list.unlink(this);
            return true;
        }

        @Override
        public void clear() {
            this.unlink();
            this.item = null;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return String.valueOf(this.item);
        }
    }

    static final class LLSpliterator<E>
    implements Spliterator<E> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        final LinkedNodeList<E> list;
        NodeImpl<E> current;
        int est;
        int expectedModCount;
        int batch;

        LLSpliterator(LinkedNodeList<E> list, int est, int expectedModCount) {
            this.list = list;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getEst() {
            int s = this.est;
            if (s < 0) {
                LinkedNodeList<E> lst = this.list;
                if (lst == null) {
                    this.est = 0;
                    s = 0;
                } else {
                    this.expectedModCount = ((LinkedNodeList)lst).modCount;
                    this.current = lst.first;
                    s = this.est = lst.size;
                }
            }
            return s;
        }

        @Override
        public long estimateSize() {
            return this.getEst();
        }

        @Override
        public Spliterator<E> trySplit() {
            NodeImpl<E> p;
            int s = this.getEst();
            if (s > 1 && (p = this.current) != null) {
                int n = this.batch + 1024;
                if (n > s) {
                    n = s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j++] = p.item;
                } while ((p = p.next) != null && j < n);
                this.current = p;
                this.batch = j;
                this.est = s - j;
                return Spliterators.spliterator(a, 0, j, 16);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            NodeImpl<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            int n = this.getEst();
            if (n > 0 && (p = this.current) != null) {
                this.current = null;
                this.est = 0;
                do {
                    Object e = p.item;
                    p = p.next;
                    action.accept(e);
                } while (p != null && --n > 0);
            }
            if (((LinkedNodeList)this.list).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            NodeImpl<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.getEst() > 0 && (p = this.current) != null) {
                --this.est;
                Object e = p.item;
                this.current = p.next;
                action.accept(e);
                if (((LinkedNodeList)this.list).modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

