/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.collections;

import java.util.ArrayList;
import java.util.Random;

public class RandomBox<E> {
    private final ArrayList<Item<E>> items;
    private final Random random;
    private int bandwidth;

    public RandomBox() {
        this.items = new ArrayList();
        this.random = new Random();
    }

    public RandomBox(Random random) {
        if (random == null) {
            throw new NullPointerException("Random cannot be null");
        }
        this.items = new ArrayList();
        this.random = random;
    }

    public RandomBox(int initialCapacity) {
        this.items = new ArrayList(initialCapacity);
        this.random = new Random();
    }

    public RandomBox(int initialCapacity, Random random) {
        if (random == null) {
            throw new NullPointerException("Random cannot be null");
        }
        this.items = new ArrayList(initialCapacity);
        this.random = random;
    }

    public void trim() {
        this.items.trimToSize();
    }

    public void add(E e, int frequency) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (frequency <= 0) {
            throw new IllegalArgumentException("Illegal frequency " + frequency);
        }
        int bandwidth = this.bandwidth + frequency;
        if (bandwidth < 0) {
            throw new IllegalStateException("overflowed bandwidth");
        }
        Item<E> item = new Item<E>(e, frequency);
        this.items.add(item);
        this.bandwidth = item.bandwidth = bandwidth;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    private int toIndex(int target) {
        ArrayList<Item<E>> items = this.items;
        int low = 0;
        int high = items.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (target >= items.get((int)mid).bandwidth) {
                low = mid + 1;
                continue;
            }
            if (mid > 0 && target <= items.get((int)(mid - 1)).bandwidth) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private int nextIndex() {
        return this.toIndex(this.random.nextInt(this.bandwidth));
    }

    public E draw() {
        if (this.bandwidth > 0) {
            return this.remove(this.nextIndex());
        }
        return null;
    }

    public E draw(int frequency) {
        if (this.bandwidth > 0) {
            return this.remove(this.toIndex(frequency));
        }
        return null;
    }

    public E remove(int index) {
        Object item = this.items.remove((int)index).item;
        this.recalculateBandwidth(index);
        return item;
    }

    public E peek() {
        return this.bandwidth > 0 ? (E)this.items.get((int)this.nextIndex()).item : null;
    }

    public E peek(int frequency) {
        return this.bandwidth > 0 ? (E)this.items.get((int)this.toIndex((int)frequency)).item : null;
    }

    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            Item<E> item = this.items.get(i);
            if (!o.equals(item.item)) continue;
            this.items.remove(i);
            this.recalculateBandwidth(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.items.clear();
        this.bandwidth = 0;
    }

    private void recalculateBandwidth(int index) {
        int bandwidth = index > 0 ? this.items.get((int)(index - 1)).bandwidth : 0;
        int size = this.items.size();
        for (int i = index; i < size; ++i) {
            Item<E> item = this.items.get(i);
            item.bandwidth = bandwidth += item.frequency;
        }
        this.bandwidth = bandwidth;
    }

    static class Item<E> {
        final E item;
        final int frequency;
        int bandwidth;

        Item(E item, int frequency) {
            this.item = item;
            this.frequency = frequency;
        }
    }
}

