/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.task.BaseTask;
import com.github.gradle.node.task.NodeSetupTask;
import com.github.gradle.node.util.ProjectApiHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0007J&\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020#H\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Lcom/github/gradle/node/task/NodeSetupTask;", "Lcom/github/gradle/node/task/BaseTask;", "()V", "download", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDownload", "()Lorg/gradle/api/provider/Property;", "nodeArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getNodeArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "nodeDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getNodeDir", "()Lorg/gradle/api/provider/Provider;", "nodeDir$delegate", "Lkotlin/Lazy;", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "projectHelper", "Lcom/github/gradle/node/util/ProjectApiHelper;", "getProjectHelper", "()Lcom/github/gradle/node/util/ProjectApiHelper;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "deleteExistingNode", "", "exec", "fixBrokenSymlink", "name", "", "nodeBinDirPath", "Ljava/nio/file/Path;", "nodeDirProvider", "setExecutableFlag", "unpackNodeArchive", "Companion", "gradle-node-plugin"})
public abstract class NodeSetupTask
extends BaseTask {
    private final NodeExtension nodeExtension;
    @NotNull
    private final Property<Boolean> download;
    @NotNull
    private final RegularFileProperty nodeArchiveFile;
    @NotNull
    private final Lazy nodeDir$delegate;
    @NotNull
    private final ProjectApiHelper projectHelper;
    @NotNull
    public static final String NAME = "nodeSetup";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Input
    @NotNull
    public final Property<Boolean> getDownload() {
        return this.download;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getNodeArchiveFile() {
        return this.nodeArchiveFile;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getNodeDir() {
        Lazy lazy = this.nodeDir$delegate;
        NodeSetupTask nodeSetupTask = this;
        Object var3_3 = null;
        return (Provider)lazy.getValue();
    }

    @Internal
    @NotNull
    public final ProjectApiHelper getProjectHelper() {
        return this.projectHelper;
    }

    @TaskAction
    public final void exec() {
        this.deleteExistingNode();
        this.unpackNodeArchive();
        this.setExecutableFlag();
    }

    private final void deleteExistingNode() {
        this.projectHelper.delete((Action<DeleteSpec>)new Action(this){
            final /* synthetic */ NodeSetupTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{((Directory)this.this$0.getNodeDir().get()).dir("../")});
            }
            {
                this.this$0 = nodeSetupTask;
            }
        });
    }

    private final void unpackNodeArchive() {
        Object object = this.nodeArchiveFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeArchiveFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeArchiveFile.get().asFile");
        File archiveFile = file;
        Provider<Directory> nodeDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeDir(this.nodeExtension);
        Provider<Directory> nodeBinDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeBinDir(nodeDirProvider);
        Provider provider = nodeDirProvider.map((Transformer)unpackNodeArchive.archivePath.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"nodeDirProvider.map { it.dir(\"../\") }");
        Provider archivePath2 = provider;
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archiveFile.name");
        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
            this.projectHelper.copy((Action<CopySpec>)new Action(this, archiveFile, archivePath2){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $archivePath;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().zipTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$archivePath);
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$archivePath = provider;
                }
            });
        } else {
            Path nodeBinDirPath;
            this.projectHelper.copy((Action<CopySpec>)new Action(this, archiveFile, archivePath2){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $archivePath;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().tarTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$archivePath);
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$archivePath = provider;
                }
            });
            Object object2 = nodeBinDirProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeBinDirProvider.get()");
            Path path = nodeBinDirPath = ((Directory)object2).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"nodeBinDirPath");
            this.fixBrokenSymlink("npm", path, nodeDirProvider);
            this.fixBrokenSymlink("npx", nodeBinDirPath, nodeDirProvider);
        }
    }

    private final void fixBrokenSymlink(String name2, Path nodeBinDirPath, Provider<Directory> nodeDirProvider) {
        Path script = nodeBinDirPath.resolve(name2);
        Object object = this.getVariantComputer$gradle_node_plugin().computeNpmScriptFile(nodeDirProvider, name2).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variantComputer.computeN\u2026eDirProvider, name).get()");
        String scriptFile = (String)object;
        if (Files.deleteIfExists(script)) {
            Files.createSymbolicLink(script, nodeBinDirPath.relativize(Paths.get(scriptFile, new String[0])), new FileAttribute[0]);
        }
    }

    private final void setExecutableFlag() {
        if (!this.getPlatformHelper().isWindows()) {
            Provider<Directory> nodeDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeDir(this.nodeExtension);
            Provider<Directory> nodeBinDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeBinDir(nodeDirProvider);
            Provider<String> nodeExecProvider = this.getVariantComputer$gradle_node_plugin().computeNodeExec(this.nodeExtension, nodeBinDirProvider);
            new File((String)nodeExecProvider.get()).setExecutable(true);
        }
    }

    public NodeSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project);
        this.download = this.nodeExtension.getDownload();
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.nodeArchiveFile = regularFileProperty;
        this.nodeDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ NodeSetupTask this$0;

            @NotNull
            public final Provider<Directory> invoke() {
                return this.this$0.getVariantComputer$gradle_node_plugin().computeNodeDir(NodeSetupTask.access$getNodeExtension$p(this.this$0));
            }
            {
                this.this$0 = nodeSetupTask;
                super(0);
            }
        }));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.projectHelper = ProjectApiHelper.Companion.newInstance(project2);
        this.setGroup("Node");
        this.setDescription("Download and install a local node/npm version.");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = nodeExtension.getDownload().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeExtension.download.get()");
                return (Boolean)object;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask$Companion;", "", "()V", "NAME", "", "gradle-node-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

