/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.npm.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.exec.NodeExecConfiguration;
import com.github.gradle.node.npm.exec.NpmExecRunner;
import com.github.gradle.node.task.BaseTask;
import com.github.gradle.node.util.ProjectApiHelper;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0014J\b\u0010'\u001a\u00020(H\u0007J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0015J\b\u0010*\u001a\u00020\nH\u0017R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000f8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u00020\u001e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006,"}, d2={"Lcom/github/gradle/node/npm/task/NpmSetupTask;", "Lcom/github/gradle/node/task/BaseTask;", "()V", "args", "Lorg/gradle/api/provider/ListProperty;", "", "getArgs", "()Lorg/gradle/api/provider/ListProperty;", "download", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDownload", "()Lorg/gradle/api/provider/Property;", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "getNodeExtension", "()Lcom/github/gradle/node/NodeExtension;", "npmDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getNpmDir", "()Lorg/gradle/api/provider/Provider;", "npmDir$delegate", "Lkotlin/Lazy;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "projectHelper", "Lcom/github/gradle/node/util/ProjectApiHelper;", "getProjectHelper", "()Lcom/github/gradle/node/util/ProjectApiHelper;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "computeCommand", "", "exec", "", "getVersion", "isTaskEnabled", "Companion", "gradle-node-plugin"})
public abstract class NpmSetupTask
extends BaseTask {
    @NotNull
    private final NodeExtension nodeExtension;
    @NotNull
    private final ProjectApiHelper projectHelper;
    @NotNull
    private final ListProperty<String> args;
    @NotNull
    private final Property<Boolean> download;
    @NotNull
    private final Lazy npmDir$delegate;
    @NotNull
    public static final String NAME = "npmSetup";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Internal
    @NotNull
    protected final NodeExtension getNodeExtension() {
        return this.nodeExtension;
    }

    @Internal
    @NotNull
    public final ProjectApiHelper getProjectHelper() {
        return this.projectHelper;
    }

    @Input
    @NotNull
    public final ListProperty<String> getArgs() {
        return this.args;
    }

    @Input
    @NotNull
    public final Property<Boolean> getDownload() {
        return this.download;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getNpmDir() {
        Lazy lazy = this.npmDir$delegate;
        NpmSetupTask npmSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @Input
    @NotNull
    protected Provider<String> getVersion() {
        return (Provider)this.nodeExtension.getNpmVersion();
    }

    @Internal
    public boolean isTaskEnabled() {
        Object object = this.nodeExtension.getNpmVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeExtension.npmVersion.get()");
        CharSequence charSequence = (CharSequence)object;
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)charSequence);
    }

    @TaskAction
    public final void exec() {
        List<String> command = this.computeCommand();
        NodeExecConfiguration nodeExecConfiguration = new NodeExecConfiguration(command, null, null, false, null, 30, null);
        Object object = this.getObjects().newInstance(NpmExecRunner.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objects.newInstance(NpmExecRunner::class.java)");
        NpmExecRunner npmExecRunner = (NpmExecRunner)object;
        npmExecRunner.executeNpmCommand(this.projectHelper, this.nodeExtension, nodeExecConfiguration, this.getVariantComputer$gradle_node_plugin());
    }

    @NotNull
    protected List<String> computeCommand() {
        Object object = this.nodeExtension.getNpmVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeExtension.npmVersion.get()");
        String version = (String)object;
        Object object2 = this.getNpmDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"npmDir.get()");
        File file = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"npmDir.get().asFile");
        File directory = file;
        new File(directory, "lib").mkdirs();
        Collection collection = CollectionsKt.listOf((Object[])new String[]{"install", "--global", "--no-save", "--prefix", directory.getAbsolutePath(), "npm@" + version});
        Object object3 = this.args.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"args.get()");
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object3));
    }

    public NpmSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.projectHelper = ProjectApiHelper.Companion.newInstance(project2);
        ObjectFactory $this$listProperty$iv = this.getObjects();
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.args = listProperty;
        this.download = this.nodeExtension.getDownload();
        this.npmDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ NpmSetupTask this$0;

            @NotNull
            public final Provider<Directory> invoke() {
                Provider<Directory> nodeDir2 = this.this$0.getVariantComputer$gradle_node_plugin().computeNodeDir(this.this$0.getNodeExtension());
                return this.this$0.getVariantComputer$gradle_node_plugin().computeNpmDir(this.this$0.getNodeExtension(), nodeDir2);
            }
            {
                this.this$0 = npmSetupTask;
                super(0);
            }
        }));
        this.setGroup("npm");
        this.setDescription("Setup a specific version of npm to be used by the build.");
        this.dependsOn(new Object[]{"nodeSetup"});
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return this.isTaskEnabled();
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/gradle/node/npm/task/NpmSetupTask$Companion;", "", "()V", "NAME", "", "gradle-node-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

