/*
 * Decompiled with CFR 0.152.
 */
package com.moowork.gradle.node.variant;

import com.moowork.gradle.node.NodeExtension;
import com.moowork.gradle.node.util.KotlinUtilsKt;
import com.moowork.gradle.node.util.PlatformHelper;
import com.moowork.gradle.node.variant.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/moowork/gradle/node/variant/VariantBuilder;", "", "ext", "Lcom/moowork/gradle/node/NodeExtension;", "platformHelper", "Lcom/moowork/gradle/node/util/PlatformHelper;", "(Lcom/moowork/gradle/node/NodeExtension;Lcom/moowork/gradle/node/util/PlatformHelper;)V", "build", "Lcom/moowork/gradle/node/variant/Variant;", "getArchiveDependency", "", "osName", "osArch", "type", "getExeDependency", "getNodeDir", "Ljava/io/File;", "getNpmDir", "getYarnDir", "hasWindowsZip", "", "gradle-node-plugin"})
public final class VariantBuilder {
    private final NodeExtension ext;
    private final PlatformHelper platformHelper;

    @NotNull
    public final Variant build() {
        String it;
        boolean $i$f$mapIf;
        CharSequence $this$mapIf$iv;
        String osName2 = this.platformHelper.getOsName();
        String osArch2 = this.platformHelper.getOsArch();
        boolean isWindows2 = this.platformHelper.isWindows();
        String nodeExec = null;
        File nodeDir2 = null;
        File nodeBinDir = null;
        String npmExec = null;
        File npmDir2 = null;
        File npmBinDir = null;
        String npmScriptFile = null;
        String npxExec = null;
        String npxScriptFile = null;
        String yarnExec = null;
        File yarnDir = null;
        File yarnBinDir = null;
        String archiveDependency = null;
        String exeDependency = null;
        if (isWindows2) {
            CharSequence charSequence;
            CharSequence charSequence2;
            CharSequence charSequence3;
            nodeExec = "node";
            nodeBinDir = nodeDir2 = this.getNodeDir(osName2, osArch2);
            $this$mapIf$iv = this.ext.getNpmCommand();
            $i$f$mapIf = false;
            it = $this$mapIf$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"npm")) {
                it = $this$mapIf$iv;
                boolean bl2 = false;
                charSequence3 = "npm.cmd";
            } else {
                charSequence3 = $this$mapIf$iv;
            }
            npmExec = charSequence3;
            $this$mapIf$iv = this.ext.getNpmVersion();
            $i$f$mapIf = false;
            npmBinDir = npmDir2 = !StringsKt.isBlank((CharSequence)$this$mapIf$iv) ? this.getNpmDir() : nodeDir2;
            String string = new File(nodeDir2, "node_modules/npm/bin/npm-cli.js").getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(nodeDir, \"node_modu\u2026npm/bin/npm-cli.js\").path");
            npmScriptFile = string;
            $this$mapIf$iv = this.ext.getNpxCommand();
            $i$f$mapIf = false;
            it = $this$mapIf$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)"npx")) {
                it = $this$mapIf$iv;
                boolean bl4 = false;
                charSequence2 = "npx.cmd";
            } else {
                charSequence2 = $this$mapIf$iv;
            }
            npxExec = charSequence2;
            String string2 = new File(nodeDir2, "node_modules/npm/bin/npx-cli.js").getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File(nodeDir, \"node_modu\u2026npm/bin/npx-cli.js\").path");
            npxScriptFile = string2;
            $this$mapIf$iv = this.ext.getYarnCommand();
            $i$f$mapIf = false;
            it = $this$mapIf$iv;
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)it, (Object)"yarn")) {
                it = $this$mapIf$iv;
                boolean bl6 = false;
                charSequence = "yarn.cmd";
            } else {
                charSequence = $this$mapIf$iv;
            }
            yarnExec = charSequence;
            yarnBinDir = yarnDir = this.getYarnDir();
            if (this.hasWindowsZip()) {
                archiveDependency = this.getArchiveDependency(osName2, osArch2, "zip");
                exeDependency = null;
            } else {
                archiveDependency = this.getArchiveDependency("linux", "x86", "tar.gz");
                exeDependency = this.getExeDependency();
            }
        } else {
            nodeExec = "node";
            nodeDir2 = this.getNodeDir(osName2, osArch2);
            nodeBinDir = new File(nodeDir2, "bin");
            npmExec = this.ext.getNpmCommand();
            $this$mapIf$iv = this.ext.getNpmVersion();
            $i$f$mapIf = false;
            npmDir2 = !StringsKt.isBlank((CharSequence)$this$mapIf$iv) ? this.getNpmDir() : nodeDir2;
            npmBinDir = new File(npmDir2, "bin");
            String string = new File(nodeDir2, "lib/node_modules/npm/bin/npm-cli.js").getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(nodeDir, \"lib/node_\u2026npm/bin/npm-cli.js\").path");
            npmScriptFile = string;
            npxExec = this.ext.getNpxCommand();
            String string3 = new File(nodeDir2, "lib/node_modules/npm/bin/npx-cli.js").getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File(nodeDir, \"lib/node_\u2026npm/bin/npx-cli.js\").path");
            npxScriptFile = string3;
            yarnExec = this.ext.getYarnCommand();
            yarnDir = this.getYarnDir();
            yarnBinDir = new File(yarnDir, "bin");
            archiveDependency = this.getArchiveDependency(osName2, osArch2, "tar.gz");
            exeDependency = null;
        }
        if (this.ext.getDownload()) {
            CharSequence charSequence;
            $this$mapIf$iv = nodeExec;
            $i$f$mapIf = false;
            it = $this$mapIf$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"node") && isWindows2) {
                it = $this$mapIf$iv;
                boolean bl7 = false;
                charSequence = "node.exe";
            } else {
                charSequence = $this$mapIf$iv;
            }
            nodeExec = charSequence;
            String string = new File(nodeBinDir, nodeExec).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(nodeBinDir, nodeExec).absolutePath");
            nodeExec = string;
            String string4 = new File(npmBinDir, npmExec).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"File(npmBinDir, npmExec).absolutePath");
            npmExec = string4;
            String string5 = new File(npmBinDir, npxExec).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"File(npmBinDir, npxExec).absolutePath");
            npxExec = string5;
            String string6 = new File(yarnBinDir, yarnExec).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"File(yarnBinDir, yarnExec).absolutePath");
            yarnExec = string6;
        }
        return new Variant(isWindows2, nodeExec, nodeDir2, nodeBinDir, npmExec, npmDir2, npmBinDir, npmScriptFile, npxExec, npxScriptFile, yarnExec, yarnDir, yarnBinDir, archiveDependency, exeDependency);
    }

    private final String getArchiveDependency(String osName2, String osArch2, String type) {
        String version = this.ext.getVersion();
        return "org.nodejs:node:" + version + ':' + osName2 + '-' + osArch2 + '@' + type;
    }

    private final String getExeDependency() {
        String string = (String)CollectionsKt.first(KotlinUtilsKt.tokenize(this.ext.getVersion(), "."));
        boolean bl = false;
        int majorVersion = Integer.parseInt(string);
        return majorVersion > 3 ? (Intrinsics.areEqual((Object)this.platformHelper.getOsArch(), (Object)"x86") ? "org.nodejs:win-x86/node:" + this.ext.getVersion() + "@exe" : "org.nodejs:win-x64/node:" + this.ext.getVersion() + "@exe") : (Intrinsics.areEqual((Object)this.platformHelper.getOsArch(), (Object)"x86") ? "org.nodejs:node:" + this.ext.getVersion() + "@exe" : "org.nodejs:x64/node:" + this.ext.getVersion() + "@exe");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasWindowsZip() {
        void minorVersion;
        void majorVersion;
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = KotlinUtilsKt.tokenize(this.ext.getVersion(), ".");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_10 = it;
            boolean bl2 = false;
            Integer n = Integer.parseInt((String)var14_10);
            collection.add(n);
        }
        List list2 = list = (List)destination$iv$iv;
        boolean bl = false;
        int n = ((Number)list2.get(0)).intValue();
        list2 = list;
        bl = false;
        int n2 = ((Number)list2.get(1)).intValue();
        list2 = list;
        bl = false;
        int microVersion = ((Number)list2.get(2)).intValue();
        return majorVersion == 4 && minorVersion >= 5 || majorVersion == 6 && (minorVersion > 2 || minorVersion == 2 && microVersion >= 1) || majorVersion > 6;
    }

    private final File getNpmDir() {
        return new File(this.ext.getNpmWorkDir(), "npm-v" + this.ext.getNpmVersion());
    }

    private final File getYarnDir() {
        CharSequence charSequence = this.ext.getYarnVersion();
        StringBuilder stringBuilder = new StringBuilder().append("yarn");
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        String dirname = stringBuilder.append(bl2 ? "-v" + this.ext.getYarnVersion() : "-latest").toString();
        return new File(this.ext.getYarnWorkDir(), dirname);
    }

    private final File getNodeDir(String osName2, String osArch2) {
        String version = this.ext.getVersion();
        String dirName = "node-v" + version + '-' + osName2 + '-' + osArch2;
        return new File(this.ext.getWorkDir(), dirName);
    }

    @JvmOverloads
    public VariantBuilder(@NotNull NodeExtension ext, @NotNull PlatformHelper platformHelper) {
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        Intrinsics.checkParameterIsNotNull((Object)platformHelper, (String)"platformHelper");
        this.ext = ext;
        this.platformHelper = platformHelper;
    }

    public /* synthetic */ VariantBuilder(NodeExtension nodeExtension, PlatformHelper platformHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            platformHelper = PlatformHelper.Companion.getINSTANCE();
        }
        this(nodeExtension, platformHelper);
    }

    @JvmOverloads
    public VariantBuilder(@NotNull NodeExtension ext) {
        this(ext, null, 2, null);
    }
}

