/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.socketio.client;

import com.github.nkzawa.socketio.client.Manager;
import com.github.nkzawa.socketio.client.Socket;
import com.github.nkzawa.socketio.client.Url;
import com.github.nkzawa.socketio.parser.Parser;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = Parser.protocol;

    public static void setDefaultSSLContext(SSLContext sslContext) {
        Manager.defaultSSLContext = sslContext;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        Manager.defaultHostnameVerifier = hostnameVerifier;
    }

    private IO() {
    }

    public static Socket socket(String uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(String uri, Options opts) throws URISyntaxException {
        return IO.socket(new URI(uri), opts);
    }

    public static Socket socket(URI uri) {
        return IO.socket(uri, null);
    }

    public static Socket socket(URI uri, Options opts) {
        Manager io;
        URI source;
        if (opts == null) {
            opts = new Options();
        }
        URL parsed = Url.parse(uri);
        try {
            source = parsed.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (opts.forceNew || !opts.multiplex) {
            logger.fine(String.format("ignoring socket cache for %s", source));
            io = new Manager(source, opts);
        } else {
            String id = Url.extractId(parsed);
            if (!managers.containsKey(id)) {
                logger.fine(String.format("new io instance for %s", source));
                managers.putIfAbsent(id, new Manager(source, opts));
            }
            io = managers.get(id);
        }
        return io.socket(parsed.getPath());
    }

    public static class Options
    extends Manager.Options {
        public boolean forceNew;
        public boolean multiplex = true;
    }
}

