/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.socketio.client;

import com.github.nkzawa.engineio.client.Socket;
import com.github.nkzawa.socketio.client.Manager;
import com.github.nkzawa.socketio.client.Socket;
import com.github.nkzawa.socketio.client.Url;
import com.github.nkzawa.socketio.parser.Parser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = Parser.protocol;

    private IO() {
    }

    public static Socket socket(String uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(String uri, Options opts) throws URISyntaxException {
        return IO.socket(new URI(uri), opts);
    }

    public static Socket socket(URI uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(URI uri, Options opts) throws URISyntaxException {
        Manager io;
        URL parsed;
        if (opts == null) {
            opts = new Options();
        }
        try {
            parsed = Url.parse(uri);
        }
        catch (MalformedURLException e) {
            throw new URISyntaxException(uri.toString(), e.getMessage());
        }
        URI source = parsed.toURI();
        if (opts.forceNew || !opts.multiplex) {
            logger.info(String.format("ignoring socket cache for %s", source));
            io = new Manager(source, opts);
        } else {
            String id = Url.extractId(parsed);
            if (!managers.containsKey(id)) {
                logger.info(String.format("new io instance for %s", source));
                managers.putIfAbsent(id, new Manager(source, opts));
            }
            io = managers.get(id);
        }
        return io.socket(parsed.getPath());
    }

    public static class Options
    extends Socket.Options {
        public boolean forceNew;
        public boolean multiplex = true;
        public boolean reconnection = true;
        public int reconnectionAttempts;
        public long reconnectionDelay;
        public long reconnectionDelayMax;
        public long timeout = -1L;
    }
}

