/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.engineio.parser;

import com.github.nkzawa.engineio.parser.Buffer;
import com.github.nkzawa.engineio.parser.Packet;
import com.github.nkzawa.utf8.UTF8;
import com.github.nkzawa.utf8.UTF8Exception;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Parser {
    private static final int MAX_INT_CHAR_LENGTH = String.valueOf(Integer.MAX_VALUE).length();
    public static final int protocol = 3;
    private static final Map<String, Integer> packets = new HashMap<String, Integer>(){
        {
            this.put("open", 0);
            this.put("close", 1);
            this.put("ping", 2);
            this.put("pong", 3);
            this.put("message", 4);
            this.put("upgrade", 5);
            this.put("noop", 6);
        }
    };
    private static final Map<Integer, String> packetslist = new HashMap<Integer, String>();
    private static Packet<String> err;

    private Parser() {
    }

    public static void encodePacket(Packet packet, EncodeCallback callback) {
        if (packet.data instanceof byte[]) {
            Packet _packet = packet;
            EncodeCallback _callback = callback;
            Parser.encodeByteArray(_packet, _callback);
            return;
        }
        String encoded = String.valueOf(packets.get(packet.type));
        if (null != packet.data) {
            encoded = encoded + UTF8.encode(String.valueOf(packet.data));
        }
        EncodeCallback _callback = callback;
        _callback.call(encoded);
    }

    private static void encodeByteArray(Packet<byte[]> packet, EncodeCallback<byte[]> callback) {
        byte[] data = (byte[])packet.data;
        byte[] resultArray = new byte[1 + data.length];
        resultArray[0] = packets.get(packet.type).byteValue();
        System.arraycopy(data, 0, resultArray, 1, data.length);
        callback.call(resultArray);
    }

    public static Packet<String> decodePacket(String data) {
        int type;
        try {
            type = Character.getNumericValue(data.charAt(0));
        }
        catch (IndexOutOfBoundsException e) {
            type = -1;
        }
        try {
            data = UTF8.decode(data);
        }
        catch (UTF8Exception e) {
            return err;
        }
        if (type < 0 || type >= packetslist.size()) {
            return err;
        }
        if (data.length() > 1) {
            return new Packet<String>(packetslist.get(type), data.substring(1));
        }
        return new Packet<String>(packetslist.get(type));
    }

    public static Packet<byte[]> decodePacket(byte[] data) {
        byte type = data[0];
        byte[] intArray = new byte[data.length - 1];
        System.arraycopy(data, 1, intArray, 0, intArray.length);
        return new Packet<byte[]>(packetslist.get(type), intArray);
    }

    public static void encodePayload(Packet[] packets, EncodeCallback<byte[]> callback) {
        if (packets.length == 0) {
            callback.call(new byte[0]);
            return;
        }
        final ArrayList results = new ArrayList(packets.length);
        for (Packet packet : packets) {
            Parser.encodePacket(packet, new EncodeCallback(){

                public void call(Object packet) {
                    if (packet instanceof String) {
                        String encodingLength = String.valueOf(((String)packet).length());
                        byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                        sizeBuffer[0] = 0;
                        for (int i = 0; i < encodingLength.length(); ++i) {
                            sizeBuffer[i + 1] = (byte)Character.getNumericValue(encodingLength.charAt(i));
                        }
                        sizeBuffer[sizeBuffer.length - 1] = -1;
                        results.add(Buffer.concat(new byte[][]{sizeBuffer, Parser.stringToByteArray((String)packet)}));
                        return;
                    }
                    String encodingLength = String.valueOf(((byte[])packet).length);
                    byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                    sizeBuffer[0] = 1;
                    for (int i = 0; i < encodingLength.length(); ++i) {
                        sizeBuffer[i + 1] = (byte)Character.getNumericValue(encodingLength.charAt(i));
                    }
                    sizeBuffer[sizeBuffer.length - 1] = -1;
                    results.add(Buffer.concat(new byte[][]{sizeBuffer, (byte[])packet}));
                }
            });
        }
        callback.call(Buffer.concat((byte[][])results.toArray((T[])new byte[results.size()][])));
    }

    public static void decodePayload(String data, DecodePayloadCallback<String> callback) {
        if (data == null || data.isEmpty()) {
            callback.call(err, 0, 1);
            return;
        }
        StringBuilder length = new StringBuilder();
        int l = data.length();
        for (int i = 0; i < l; ++i) {
            String msg;
            int n;
            char chr = data.charAt(i);
            if (':' != chr) {
                length.append(chr);
                continue;
            }
            try {
                n = Integer.parseInt(length.toString());
            }
            catch (NumberFormatException e) {
                callback.call(err, 0, 1);
                return;
            }
            try {
                msg = data.substring(i + 1, i + 1 + n);
            }
            catch (IndexOutOfBoundsException e) {
                callback.call(err, 0, 1);
                return;
            }
            if (msg.length() != 0) {
                Packet<String> packet = Parser.decodePacket(msg);
                if (Parser.err.type.equals(packet.type) && ((String)Parser.err.data).equals(packet.data)) {
                    callback.call(err, 0, 1);
                    return;
                }
                boolean ret = callback.call(packet, i + n, l);
                if (!ret) {
                    return;
                }
            }
            i += n;
            length = new StringBuilder();
        }
        if (length.length() > 0) {
            callback.call(err, 0, 1);
        }
    }

    public static void decodePayload(byte[] data, DecodePayloadCallback callback) {
        ByteBuffer bufferTail = ByteBuffer.wrap(data);
        ArrayList<Object> buffers = new ArrayList<Object>();
        while (bufferTail.capacity() > 0) {
            int b;
            StringBuilder strLen = new StringBuilder();
            boolean isString = (bufferTail.get(0) & 0xFF) == 0;
            boolean numberTooLong = false;
            int i = 1;
            while ((b = bufferTail.get(i) & 0xFF) != 255) {
                if (strLen.length() > MAX_INT_CHAR_LENGTH) {
                    numberTooLong = true;
                    break;
                }
                strLen.append(b);
                ++i;
            }
            if (numberTooLong) {
                DecodePayloadCallback _callback = callback;
                _callback.call(err, 0, 1);
                return;
            }
            bufferTail.position(strLen.length() + 1);
            bufferTail = bufferTail.slice();
            int msgLength = Integer.parseInt(strLen.toString());
            bufferTail.position(1);
            bufferTail.limit(msgLength + 1);
            byte[] msg = new byte[bufferTail.remaining()];
            bufferTail.get(msg);
            if (isString) {
                buffers.add(Parser.byteArrayToString(msg));
            } else {
                buffers.add(msg);
            }
            bufferTail.clear();
            bufferTail.position(msgLength + 1);
            bufferTail = bufferTail.slice();
        }
        int total = buffers.size();
        for (int i = 0; i < total; ++i) {
            DecodePayloadCallback _callback;
            Object buffer = buffers.get(i);
            if (buffer instanceof String) {
                _callback = callback;
                _callback.call(Parser.decodePacket((String)buffer), i, total);
                continue;
            }
            if (!(buffer instanceof byte[])) continue;
            _callback = callback;
            _callback.call(Parser.decodePacket((byte[])buffer), i, total);
        }
    }

    private static String byteArrayToString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.appendCodePoint(b & 0xFF);
        }
        return builder.toString();
    }

    private static byte[] stringToByteArray(String string) {
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)Character.codePointAt(string, i);
        }
        return bytes;
    }

    static {
        for (Map.Entry<String, Integer> entry : packets.entrySet()) {
            packetslist.put(entry.getValue(), entry.getKey());
        }
        err = new Packet<String>("error", "parser error");
    }

    public static interface DecodePayloadCallback<T> {
        public boolean call(Packet<T> var1, int var2, int var3);
    }

    public static interface EncodeCallback<T> {
        public void call(T var1);
    }
}

