/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.engineio.client.transports;

import com.github.nkzawa.engineio.client.Transport;
import com.github.nkzawa.engineio.parser.Packet;
import com.github.nkzawa.engineio.parser.Parser;
import com.github.nkzawa.parseqs.ParseQS;
import com.github.nkzawa.thread.EventThread;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private WebSocketClient ws;

    public WebSocket(Transport.Options opts) {
        super(opts);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        if (!this.check()) {
            return;
        }
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.emit("requestHeaders", headers);
        final WebSocket self = this;
        try {
            this.ws = new WebSocketClient(new URI(this.uri()), (Draft)new Draft_17(), headers, 0){

                public void onOpen(final ServerHandshake serverHandshake) {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                            Iterator it = serverHandshake.iterateHttpFields();
                            while (it.hasNext()) {
                                String field = (String)it.next();
                                if (field == null) continue;
                                headers.put(field, serverHandshake.getFieldValue(field));
                            }
                            self.emit("responseHeaders", headers);
                            self.onOpen();
                        }
                    });
                }

                public void onClose(int i, String s, boolean b) {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            self.onClose();
                        }
                    });
                }

                public void onMessage(final String s) {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            self.onData(s);
                        }
                    });
                }

                public void onMessage(final ByteBuffer s) {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            self.onData(s.array());
                        }
                    });
                }

                public void onError(final Exception e) {
                    EventThread.exec(new Runnable(){

                        @Override
                        public void run() {
                            self.onError("websocket error", e);
                        }
                    });
                }
            };
            this.ws.connect();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void write(Packet[] packets) {
        final WebSocket self = this;
        this.writable = false;
        for (Packet packet : packets) {
            Parser.encodePacket(packet, new Parser.EncodeCallback(){

                public void call(Object packet) {
                    if (packet instanceof String) {
                        self.ws.send((String)packet);
                    } else if (packet instanceof byte[]) {
                        self.ws.send((byte[])packet);
                    }
                }
            });
        }
        Runnable ondrain = new Runnable(){

            @Override
            public void run() {
                self.writable = true;
                self.emit("drain", new Object[0]);
            }
        };
        EventThread.nextTick(ondrain);
    }

    @Override
    protected void onClose() {
        super.onClose();
    }

    @Override
    protected void doClose() {
        if (this.ws != null) {
            this.ws.close();
        }
    }

    protected String uri() {
        String _query;
        HashMap<String, String> query = this.query;
        if (query == null) {
            query = new HashMap<String, String>();
        }
        String schema = this.secure ? "wss" : "ws";
        String port = "";
        if (this.port > 0 && ("wss".equals(schema) && this.port != 443 || "ws".equals(schema) && this.port != 80)) {
            port = ":" + this.port;
        }
        if (this.timestampRequests) {
            query.put(this.timestampParam, String.valueOf(new Date().getTime()));
        }
        if ((_query = ParseQS.encode(query)).length() > 0) {
            _query = "?" + _query;
        }
        return schema + "://" + this.hostname + port + this.path + _query;
    }

    private boolean check() {
        return true;
    }
}

