/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.engineio.parser;

import com.github.nkzawa.engineio.parser.Packet;
import java.util.HashMap;
import java.util.Map;

public class Parser {
    public static final int protocol = 2;
    private static final Map<String, Integer> packets = new HashMap<String, Integer>(){
        {
            this.put("open", 0);
            this.put("close", 1);
            this.put("ping", 2);
            this.put("pong", 3);
            this.put("message", 4);
            this.put("upgrade", 5);
            this.put("noop", 6);
        }
    };
    private static final Map<Integer, String> bipackets = new HashMap<Integer, String>();
    private static Packet err;

    private Parser() {
    }

    public static String encodePacket(Packet packet) {
        String encoded = String.valueOf(packets.get(packet.type));
        if (packet.data != null) {
            encoded = encoded + packet.data;
        }
        return encoded;
    }

    public static Packet decodePacket(String data) {
        int type = -1;
        try {
            type = Character.getNumericValue(data.charAt(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (type < 0 || type >= packets.size()) {
            return err;
        }
        return new Packet(bipackets.get(type), data.length() > 1 ? data.substring(1) : null);
    }

    public static String encodePayload(Packet[] packets) {
        if (packets.length == 0) {
            return "0:";
        }
        StringBuilder encoded = new StringBuilder();
        for (Packet packet : packets) {
            String message = Parser.encodePacket(packet);
            encoded.append(message.length()).append(":").append(message);
        }
        return encoded.toString();
    }

    public static void decodePayload(String data, DecodePayloadCallback callback) {
        if (data == null || data.isEmpty()) {
            callback.call(err, 0, 1);
            return;
        }
        StringBuilder length = new StringBuilder();
        int l = data.length();
        for (int i = 0; i < l; ++i) {
            String msg;
            int n;
            char chr = data.charAt(i);
            if (':' != chr) {
                length.append(chr);
                continue;
            }
            try {
                n = Integer.parseInt(length.toString());
            }
            catch (NumberFormatException e) {
                callback.call(err, 0, 1);
                return;
            }
            try {
                msg = data.substring(i + 1, i + 1 + n);
            }
            catch (IndexOutOfBoundsException e) {
                callback.call(err, 0, 1);
                return;
            }
            if (msg.length() != 0) {
                Packet packet = Parser.decodePacket(msg);
                if (Parser.err.type.equals(packet.type) && Parser.err.data.equals(packet.data)) {
                    callback.call(err, 0, 1);
                    return;
                }
                boolean ret = callback.call(packet, i + n, l);
                if (!ret) {
                    return;
                }
            }
            i += n;
            length = new StringBuilder();
        }
        if (length.length() > 0) {
            callback.call(err, 0, 1);
        }
    }

    static {
        for (Map.Entry<String, Integer> entry : packets.entrySet()) {
            bipackets.put(entry.getValue(), entry.getKey());
        }
        err = new Packet("error", "parser error");
    }

    public static interface DecodePayloadCallback {
        public boolean call(Packet var1, int var2, int var3);
    }
}

