/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.engineio.client.transports;

import com.github.nkzawa.emitter.Emitter;
import com.github.nkzawa.engineio.client.EventThread;
import com.github.nkzawa.engineio.client.Transport;
import com.github.nkzawa.engineio.client.Util;
import com.github.nkzawa.engineio.parser.Packet;
import com.github.nkzawa.engineio.parser.Parser;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class Polling
extends Transport {
    private static final Logger logger = Logger.getLogger(Polling.class.getName());
    public static final String NAME = "polling";
    public static final String EVENT_POLL = "poll";
    public static final String EVENT_POLL_COMPLETE = "pollComplete";
    private boolean polling;

    public Polling(Transport.Options opts) {
        super(opts);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        this.poll();
    }

    public void pause(final Runnable onPause) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                final Polling self = Polling.this;
                Polling.this.readyState = Transport.ReadyState.PAUSED;
                final Runnable pause = new Runnable(){

                    @Override
                    public void run() {
                        logger.fine("paused");
                        self.readyState = Transport.ReadyState.PAUSED;
                        onPause.run();
                    }
                };
                if (Polling.this.polling || !Polling.this.writable) {
                    final int[] total = new int[]{0};
                    if (Polling.this.polling) {
                        logger.fine("we are currently polling - waiting to pause");
                        total[0] = total[0] + 1;
                        Polling.this.once(Polling.EVENT_POLL_COMPLETE, new Emitter.Listener(){

                            @Override
                            public void call(Object ... args) {
                                logger.fine("pre-pause polling complete");
                                total[0] = total[0] - 1;
                                if (total[0] == 0) {
                                    pause.run();
                                }
                            }
                        });
                    }
                    if (!Polling.this.writable) {
                        logger.fine("we are currently writing - waiting to pause");
                        total[0] = total[0] + 1;
                        Polling.this.once("drain", new Emitter.Listener(){

                            @Override
                            public void call(Object ... args) {
                                logger.fine("pre-pause writing complete");
                                total[0] = total[0] - 1;
                                if (total[0] == 0) {
                                    pause.run();
                                }
                            }
                        });
                    }
                } else {
                    pause.run();
                }
            }
        });
    }

    private void poll() {
        logger.fine(NAME);
        this.polling = true;
        this.doPoll();
        this.emit(EVENT_POLL, new Object[0]);
    }

    @Override
    protected void onData(String data) {
        final Polling self = this;
        logger.fine(String.format("polling got data %s", data));
        Parser.decodePayload(data, new Parser.DecodePayloadCallback(){

            @Override
            public boolean call(Packet packet, int index, int total) {
                if (self.readyState == Transport.ReadyState.OPENING) {
                    self.onOpen();
                }
                if ("close".equals(packet.type)) {
                    self.onClose();
                    return false;
                }
                self.onPacket(packet);
                return true;
            }
        });
        if (this.readyState != Transport.ReadyState.CLOSED) {
            this.polling = false;
            this.emit(EVENT_POLL_COMPLETE, new Object[0]);
            if (this.readyState == Transport.ReadyState.OPEN) {
                this.poll();
            } else {
                logger.fine(String.format("ignoring poll - transport state '%s'", new Object[]{this.readyState}));
            }
        }
    }

    @Override
    protected void doClose() {
        logger.fine("sending close packet");
        this.send(new Packet[]{new Packet("close", null)});
    }

    @Override
    protected void write(Packet[] packets) {
        final Polling self = this;
        this.writable = false;
        this.doWrite(Parser.encodePayload(packets), new Runnable(){

            @Override
            public void run() {
                self.writable = true;
                self.emit("drain", new Object[0]);
            }
        });
    }

    protected String uri() {
        HashMap<String, String> query = this.query;
        if (query == null) {
            query = new HashMap<String, String>();
        }
        String schema = this.secure ? "https" : "http";
        String port = "";
        if (this.timestampRequests) {
            query.put(this.timestampParam, String.valueOf(new Date().getTime()));
        }
        String _query = Util.qs(query);
        if (this.port > 0 && ("https".equals(schema) && this.port != 443 || "http".equals(schema) && this.port != 80)) {
            port = ":" + this.port;
        }
        if (_query.length() > 0) {
            _query = "?" + _query;
        }
        return schema + "://" + this.hostname + port + this.path + _query;
    }

    protected abstract void doWrite(String var1, Runnable var2);

    protected abstract void doPoll();
}

