/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.github.niqdev.mjpeg.MjpegInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MjpegInputStreamDefault
extends MjpegInputStream {
    private static final String TAG = MjpegInputStream.class.getSimpleName();
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOF_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length";
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 40100;
    private int mContentLength = -1;

    MjpegInputStreamDefault(InputStream in) {
        super(new BufferedInputStream(in, 40100));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        int seqIndex = 0;
        for (int i = 0; i < 40100; ++i) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[seqIndex]) {
                if (++seqIndex != sequence.length) continue;
                return i + 1;
            }
            seqIndex = 0;
        }
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, IllegalArgumentException {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(headerBytes);
        Properties props = new Properties();
        props.load(headerIn);
        return Integer.parseInt(props.getProperty("Content-Length"));
    }

    Bitmap readMjpegFrame() throws IOException {
        this.mark(40100);
        int headerLen = this.getStartOfSequence(this, this.SOI_MARKER);
        this.reset();
        byte[] header = new byte[headerLen];
        this.readFully(header);
        try {
            this.mContentLength = this.parseContentLength(header);
        }
        catch (IllegalArgumentException iae) {
            this.mContentLength = this.getEndOfSeqeunce(this, this.EOF_MARKER);
        }
        this.reset();
        byte[] frameData = new byte[this.mContentLength];
        this.skipBytes(headerLen);
        this.readFully(frameData);
        return BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(frameData));
    }
}

