/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.github.niqdev.mjpeg.Mjpeg$$Lambda$1;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegInputStreamDefault;
import com.github.niqdev.mjpeg.MjpegInputStreamNative;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

public class Mjpeg {
    private final Type type;

    private Mjpeg(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("null type not allowed");
        }
        this.type = type;
    }

    public static Mjpeg newInstance() {
        return new Mjpeg(Type.DEFAULT);
    }

    public static Mjpeg newInstance(Type type) {
        return new Mjpeg(type);
    }

    public Mjpeg credential(final String username, final String password) {
        if (!TextUtils.isEmpty((CharSequence)username) && !TextUtils.isEmpty((CharSequence)password)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        return this;
    }

    @NonNull
    private Observable<MjpegInputStream> connect(String url) {
        return Observable.defer((Func0)Mjpeg$$Lambda$1.lambdaFactory$(this, url));
    }

    public Observable<MjpegInputStream> open(String url) {
        return this.connect(url).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<MjpegInputStream> open(String url, int timeout) {
        return this.connect(url).timeout((long)timeout, TimeUnit.SECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    /* synthetic */ Observable lambda$connect$0(String url) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            switch (this.type) {
                case DEFAULT: {
                    return Observable.just((Object)new MjpegInputStreamDefault(inputStream));
                }
                case NATIVE: {
                    return Observable.just((Object)new MjpegInputStreamNative(inputStream));
                }
            }
            throw new IllegalStateException("invalid type");
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
    }

    public static enum Type {
        DEFAULT,
        NATIVE;

    }
}

