/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;

@TargetApi(value=19)
public class StatusBarCompatKitKat {
    private static final int TYPE_SET_STATUS_BAR = 0;
    private static final int TYPE_SET_STATUS_BAR_WITH_COLLAPSING = 1;
    private static final int TYPE_TRANSLUCENT_STATUS_BAR = 2;

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    public static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        if (mDecorView.getTag() != null && mDecorView.getTag() instanceof Integer) {
            int type;
            View mStatusBarView = mDecorView.getChildAt(0);
            if (mStatusBarView != null) {
                mStatusBarView.setBackgroundColor(statusColor);
            }
            if (mContentChild != null) {
                ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
            }
            if ((type = ((Integer)mDecorView.getTag()).intValue()) != 0) {
                StatusBarCompatKitKat.addMarginTopToContentChild(mContentChild, StatusBarCompatKitKat.getStatusBarHeight((Context)activity));
                mDecorView.setTag((Object)0);
            }
        } else {
            int statusBarHeight = StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
            if (mContentChild != null) {
                ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
                StatusBarCompatKitKat.addMarginTopToContentChild(mContentChild, statusBarHeight);
            }
            View mStatusBarView = new View((Context)activity);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, statusBarHeight);
            layoutParams.gravity = 48;
            mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            mStatusBarView.setBackgroundColor(statusColor);
            mDecorView.addView(mStatusBarView, 0);
            mDecorView.setTag((Object)0);
        }
    }

    private static void addMarginTopToContentChild(View mContentChild, int margin) {
        if (mContentChild == null) {
            return;
        }
        if (mContentChild.getTag() == null || mContentChild.getTag() instanceof Integer && (Integer)mContentChild.getTag() != 0) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin += margin;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag((Object)0);
        }
    }

    private static void removeMarginTopOfContentChild(View mContentChild, int margin, int tag) {
        if (mContentChild == null) {
            return;
        }
        if (mContentChild.getTag() != null && mContentChild.getTag() instanceof Integer && (Integer)mContentChild.getTag() == 0) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin -= margin;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag((Object)tag);
        }
    }

    public static void setStatusBarColorForCollapsingToolbar(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        int statusBarHeight = StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
        View mContentChild = mContentView.getChildAt(0);
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        if (mDecorView.getTag() != null && mDecorView.getTag() instanceof Integer) {
            int type;
            View mStatusBarView = mDecorView.getChildAt(0);
            if (mStatusBarView != null) {
                mStatusBarView.setBackgroundColor(statusColor);
            }
            if ((type = ((Integer)mDecorView.getTag()).intValue()) != 1) {
                StatusBarCompatKitKat.removeMarginTopOfContentChild(mContentChild, statusBarHeight, 1);
                mDecorView.setTag((Object)1);
            }
        } else {
            View mStatusBarView = new View((Context)activity);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, statusBarHeight);
            layoutParams.gravity = 48;
            mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            mStatusBarView.setBackgroundColor(statusColor);
            mDecorView.addView(mStatusBarView, 0);
            mDecorView.setTag((Object)1);
        }
    }

    public static void translucentStatusBar(Activity activity) {
        int type;
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        int statusBarHeight = StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        if (mContentChild != null) {
            ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
        }
        if (mDecorView.getTag() != null && mDecorView.getTag() instanceof Integer && (type = ((Integer)mDecorView.getTag()).intValue()) != 2) {
            StatusBarCompatKitKat.removeMarginTopOfContentChild(mContentChild, statusBarHeight, 2);
            mContentChild = mContentView.getChildAt(0);
            if (mContentChild != null) {
                ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
            }
            mDecorView.setTag((Object)2);
        }
    }
}

