/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

@TargetApi(value=21)
class StatusBarCompatLollipop {
    StatusBarCompatLollipop() {
    }

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(statusColor);
        window.getDecorView().setSystemUiVisibility(0);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        Window window = activity.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        if (hideStatusBarBackground) {
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
            window.getDecorView().setSystemUiVisibility(1280);
        } else {
            window.addFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(0);
        }
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
    }

    static void setStatusBarColorForCollapsingToolbar(Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, final int statusColor) {
        CoordinatorLayout.Behavior behavior;
        final Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        window.getDecorView().setSystemUiVisibility(0);
        ViewCompat.setOnApplyWindowInsetsListener((View)collapsingToolbarLayout, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return insets;
            }
        });
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
            ViewCompat.requestApplyInsets((View)mChildView);
        }
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(false);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            int statusBarHeight = StatusBarCompatLollipop.getStatusBarHeight((Context)activity);
            lp.height += statusBarHeight;
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setPadding(toolbar.getPaddingLeft(), toolbar.getPaddingTop() + statusBarHeight, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
            toolbar.setTag((Object)true);
        }
        if ((behavior = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior()) != null && behavior instanceof AppBarLayout.Behavior) {
            int verticalOffset = ((AppBarLayout.Behavior)behavior).getTopAndBottomOffset();
            if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                window.setStatusBarColor(statusColor);
            } else {
                window.setStatusBarColor(0);
            }
        } else {
            window.setStatusBarColor(0);
        }
        collapsingToolbarLayout.setFitsSystemWindows(false);
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                    if (window.getStatusBarColor() == 0) {
                        ValueAnimator animator = ValueAnimator.ofArgb((int[])new int[]{0, statusColor}).setDuration(collapsingToolbarLayout.getScrimAnimationDuration());
                        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                                window.setStatusBarColor(((Integer)valueAnimator.getAnimatedValue()).intValue());
                            }
                        });
                        animator.start();
                    }
                } else if (window.getStatusBarColor() == statusColor) {
                    ValueAnimator animator = ValueAnimator.ofArgb((int[])new int[]{statusColor, 0}).setDuration(collapsingToolbarLayout.getScrimAnimationDuration());
                    animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator valueAnimator) {
                            window.setStatusBarColor(((Integer)valueAnimator.getAnimatedValue()).intValue());
                        }
                    });
                    animator.start();
                }
            }
        });
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        collapsingToolbarLayout.setStatusBarScrimColor(statusColor);
    }
}

