/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;

@TargetApi(value=19)
class StatusBarCompatKitKat {
    private static final String TAG_FAKE_STATUS_BAR_VIEW = "statusBarView";
    private static final String TAG_MARGIN_ADDED = "marginAdded";

    StatusBarCompatKitKat() {
    }

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    private static View addFakeStatusBarView(Activity activity, int statusBarColor, int statusBarHeight) {
        Window window = activity.getWindow();
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        View mStatusBarView = new View((Context)activity);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, statusBarHeight);
        layoutParams.gravity = 48;
        mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        mStatusBarView.setBackgroundColor(statusBarColor);
        mStatusBarView.setTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        mDecorView.addView(mStatusBarView);
        return mStatusBarView;
    }

    private static void removeFakeStatusBarViewIfExist(Activity activity) {
        Window window = activity.getWindow();
        ViewGroup mDecorView = (ViewGroup)window.getDecorView();
        View fakeView = mDecorView.findViewWithTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        if (fakeView != null) {
            mDecorView.removeView(fakeView);
        }
    }

    private static void addMarginTopToContentChild(View mContentChild, int statusBarHeight) {
        if (mContentChild == null) {
            return;
        }
        if (!TAG_MARGIN_ADDED.equals(mContentChild.getTag())) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin += statusBarHeight;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag((Object)TAG_MARGIN_ADDED);
        }
    }

    private static void removeMarginTopOfContentChild(View mContentChild, int statusBarHeight) {
        if (mContentChild == null) {
            return;
        }
        if (TAG_MARGIN_ADDED.equals(mContentChild.getTag())) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)mContentChild.getLayoutParams();
            lp.topMargin -= statusBarHeight;
            mContentChild.setLayoutParams((ViewGroup.LayoutParams)lp);
            mContentChild.setTag(null);
        }
    }

    static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        int statusBarHeight = StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
        StatusBarCompatKitKat.removeFakeStatusBarViewIfExist(activity);
        StatusBarCompatKitKat.addFakeStatusBarView(activity, statusColor, statusBarHeight);
        StatusBarCompatKitKat.addMarginTopToContentChild(mContentChild, statusBarHeight);
        if (mContentChild != null) {
            ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
        }
    }

    static void translucentStatusBar(Activity activity) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        StatusBarCompatKitKat.removeFakeStatusBarViewIfExist(activity);
        StatusBarCompatKitKat.removeMarginTopOfContentChild(mContentChild, StatusBarCompatKitKat.getStatusBarHeight((Context)activity));
        if (mContentChild != null) {
            ViewCompat.setFitsSystemWindows((View)mContentChild, (boolean)false);
        }
    }

    static void setStatusBarColorForCollapsingToolbar(Activity activity, AppBarLayout appBarLayout, final CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, int statusColor) {
        Window window = activity.getWindow();
        window.addFlags(0x4000000);
        ViewGroup mContentView = (ViewGroup)window.findViewById(0x1020002);
        View mContentChild = mContentView.getChildAt(0);
        mContentChild.setFitsSystemWindows(false);
        ((View)appBarLayout.getParent()).setFitsSystemWindows(false);
        appBarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.setFitsSystemWindows(false);
        collapsingToolbarLayout.getChildAt(0).setFitsSystemWindows(false);
        toolbar.setFitsSystemWindows(true);
        if (toolbar.getTag() == null) {
            CollapsingToolbarLayout.LayoutParams lp = (CollapsingToolbarLayout.LayoutParams)toolbar.getLayoutParams();
            lp.height += StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
            toolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            toolbar.setTag((Object)true);
        }
        int statusBarHeight = StatusBarCompatKitKat.getStatusBarHeight((Context)activity);
        StatusBarCompatKitKat.removeFakeStatusBarViewIfExist(activity);
        StatusBarCompatKitKat.removeMarginTopOfContentChild(mContentChild, statusBarHeight);
        final View statusView = StatusBarCompatKitKat.addFakeStatusBarView(activity, statusColor, statusBarHeight);
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior();
        if (behavior != null && behavior instanceof AppBarLayout.Behavior) {
            int verticalOffset = ((AppBarLayout.Behavior)behavior).getTopAndBottomOffset();
            if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                statusView.setAlpha(1.0f);
            } else {
                statusView.setAlpha(0.0f);
            }
        } else {
            statusView.setAlpha(0.0f);
        }
        appBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (Math.abs(verticalOffset) > appBarLayout.getHeight() - collapsingToolbarLayout.getScrimVisibleHeightTrigger()) {
                    if (statusView.getAlpha() == 0.0f) {
                        statusView.animate().cancel();
                        statusView.animate().alpha(1.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                    }
                } else if (statusView.getAlpha() == 1.0f) {
                    statusView.animate().cancel();
                    statusView.animate().alpha(0.0f).setDuration(collapsingToolbarLayout.getScrimAnimationDuration()).start();
                }
            }
        });
    }
}

