/*
 * Decompiled with CFR 0.152.
 */
package qiu.niorgai;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;

public class StatusBarCompat {
    public static final String TAG = StatusBarCompat.class.getName();
    public static final int COLOR_DEFAULT_WHITE = Color.parseColor((String)"#FFFFFFFF");
    public static final int COLOR_DEFAULT_PINK = Color.parseColor((String)"#FFEF4968");

    public static void setStatusBarColor(Activity activity) {
        StatusBarCompat.setStatusBarColor(activity, COLOR_DEFAULT_PINK);
    }

    public static void setStatusBarColor(Activity activity, int statusColor, int alpha) {
        StatusBarCompat.setStatusBarColor(activity, StatusBarCompat.calculateStatusBarColor(statusColor, alpha));
    }

    public static void setStatusBarColor(Activity activity, int statusColor) {
        Window window = activity.getWindow();
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            if (Build.VERSION.SDK_INT >= 21) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(statusColor);
                View mChildView = mContentView.getChildAt(0);
                if (mChildView != null) {
                    ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)true);
                }
            } else {
                View statusBarView;
                FrameLayout.LayoutParams lp;
                int statusBarHeight = StatusBarCompat.getStatusBarHeight((Context)activity);
                View mChildView = mContentView.getChildAt(0);
                if (mChildView != null && (lp = (FrameLayout.LayoutParams)mChildView.getLayoutParams()) != null && lp.topMargin < statusBarHeight && lp.height != statusBarHeight) {
                    ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
                    lp.topMargin += statusBarHeight;
                    mChildView.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
                if ((statusBarView = mContentView.getChildAt(0)) != null && statusBarView.getLayoutParams() != null && statusBarView.getLayoutParams().height == statusBarHeight) {
                    statusBarView.setBackgroundColor(statusColor);
                    return;
                }
                statusBarView = new View((Context)activity);
                ViewGroup.LayoutParams lp2 = new ViewGroup.LayoutParams(-1, statusBarHeight);
                statusBarView.setBackgroundColor(statusColor);
                mContentView.addView(statusBarView, 0, lp2);
            }
        }
    }

    public static void translucentStatusBar(Activity activity) {
        StatusBarCompat.translucentStatusBar(activity, false);
    }

    public static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        Window window = activity.getWindow();
        ViewGroup mContentView = (ViewGroup)activity.findViewById(0x1020002);
        View mChildView = mContentView.getChildAt(0);
        if (mChildView != null) {
            ViewCompat.setFitsSystemWindows((View)mChildView, (boolean)false);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            int statusBarHeight = StatusBarCompat.getStatusBarHeight((Context)activity);
            window.addFlags(0x4000000);
            if (Build.VERSION.SDK_INT >= 21) {
                window.addFlags(Integer.MIN_VALUE);
                if (hideStatusBarBackground) {
                    window.clearFlags(0x4000000);
                    window.setStatusBarColor(Color.parseColor((String)"#00000000"));
                } else {
                    window.setStatusBarColor(Color.parseColor((String)"#55000000"));
                }
                if (mChildView != null) {
                    final View finalMChildView = mChildView;
                    window.getDecorView().post(new Runnable(){

                        @Override
                        public void run() {
                            finalMChildView.requestLayout();
                        }
                    });
                }
            } else {
                FrameLayout.LayoutParams lp;
                if (mChildView != null && mChildView.getLayoutParams() != null && mChildView.getLayoutParams().height == statusBarHeight) {
                    mContentView.removeView(mChildView);
                    mChildView = mContentView.getChildAt(0);
                }
                if (mChildView != null && (lp = (FrameLayout.LayoutParams)mChildView.getLayoutParams()) != null && lp.topMargin >= statusBarHeight) {
                    lp.topMargin -= statusBarHeight;
                    mChildView.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
            }
        }
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    private static int calculateStatusBarColor(int color, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

