/*
 * Decompiled with CFR 0.152.
 */
package co.nimblehq.recentapps.thumbnailhiding;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class HardwareKeyWatcher {
    private static final String TAG = "HardwareKeyWatcher";
    private Context mContext;
    private IntentFilter mFilter;
    private OnHardwareKeysPressedListener mListener;
    private InnerReceiver mReceiver;

    public HardwareKeyWatcher(Context context) {
        this.mContext = context;
        this.mFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mFilter.setPriority(1000);
    }

    public void setOnHardwareKeysPressedListenerListener(OnHardwareKeysPressedListener listener) {
        this.mListener = listener;
        this.mReceiver = new InnerReceiver();
    }

    public void startWatch() {
        if (this.mReceiver != null) {
            this.logForDebugging("startWatch on " + this.mContext);
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, this.mFilter);
        }
    }

    public void stopWatch() {
        if (this.mReceiver != null) {
            this.logForDebugging("stopWatch on " + this.mContext);
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    private void logForDebugging(String message) {
    }

    private void logForInfo(String message) {
    }

    class InnerReceiver
    extends BroadcastReceiver {
        final String SYSTEM_DIALOG_REASON_KEY = "reason";
        final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
        final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
        final String SYSTEM_DIALOG_REASON_RECENT_APPS_XIAOMI = "fs_gesture";

        InnerReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String reason;
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) && (reason = intent.getStringExtra("reason")) != null) {
                HardwareKeyWatcher.this.logForInfo("action:" + action + ", reason:" + reason);
                if (HardwareKeyWatcher.this.mListener != null) {
                    switch (reason) {
                        case "homekey": {
                            HardwareKeyWatcher.this.logForDebugging("onHomePressed (homekey)");
                            HardwareKeyWatcher.this.mListener.onHomePressed();
                            break;
                        }
                        case "recentapps": {
                            HardwareKeyWatcher.this.logForDebugging("onRecentAppsPressed (recentapps)");
                            HardwareKeyWatcher.this.mListener.onRecentAppsPressed();
                            break;
                        }
                        case "fs_gesture": {
                            HardwareKeyWatcher.this.logForDebugging("onRecentAppsPressed (fs_gesture)");
                            HardwareKeyWatcher.this.mListener.onRecentAppsPressed();
                        }
                    }
                }
            }
        }
    }

    public static interface OnHardwareKeysPressedListener {
        public void onHomePressed();

        public void onRecentAppsPressed();
    }
}

