/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import com.github.nikartm.support.AnimatedStripedDrawable;
import com.github.nikartm.support.AttributeController;
import com.github.nikartm.support.StripedDrawable;
import com.github.nikartm.support.Util;

public class StripedProcessButton
extends AppCompatButton
implements Animatable {
    private AnimatedStripedDrawable animatedDrawable;
    private StripedDrawable stripedDrawable;
    private State state = State.STOP;
    private long startAnimDuration = -1L;
    private long stopAnimDuration = -1L;
    private boolean buttonAnimated = true;
    private String defaultText;
    private float density;

    public StripedProcessButton(Context context) {
        super(context);
        this.initAttrs(null);
    }

    public StripedProcessButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
    }

    public StripedProcessButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        this.density = this.getContext().getResources().getDisplayMetrics().density;
        AttributeController attrController = new AttributeController(this.getContext(), attrs);
        this.stripedDrawable = attrController.getStripedDrawable();
        this.animatedDrawable = new AnimatedStripedDrawable(this.stripedDrawable);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.defaultText = this.getText() != null ? this.getText().toString() : "";
        this.launchAnimationWithDelay();
    }

    private void launchAnimationWithDelay() {
        switch (this.state) {
            case START: {
                this.start();
                break;
            }
            case STOP: {
                this.stop();
                break;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        this.setBackground(this.animatedDrawable);
        this.setEnabled(!this.isRunning());
        super.onDraw(canvas);
    }

    public void start() {
        this.state = State.START;
        if (this.isRunning() || !this.isAttachedToWindow()) {
            return;
        }
        this.setEnabled(this.isRunning());
        this.animatedDrawable.start();
        this.animateButton(this.isRunning());
    }

    public void stop() {
        this.state = State.STOP;
        if (!this.isRunning() || !this.isAttachedToWindow()) {
            return;
        }
        this.setEnabled(this.isRunning());
        this.animatedDrawable.stop();
        this.animateButton(this.isRunning());
    }

    public boolean isRunning() {
        return this.isAttachedToWindow() && this.animatedDrawable.isRunning();
    }

    private void animateButton(boolean start) {
        if (this.isButtonAnimated()) {
            long duration = start ? (this.startAnimDuration == -1L ? 700L : this.startAnimDuration) : (this.stopAnimDuration == -1L ? 300L : this.stopAnimDuration);
            this.setCurrentText(start);
            Util.Animation.animateView((View)this, start, duration);
        }
    }

    private void setCurrentText(boolean start) {
        String currentText = start ? (this.stripedDrawable.getLoadingText() == null ? this.defaultText : this.stripedDrawable.getLoadingText()) : this.defaultText;
        this.setText(currentText);
    }

    public long getStartAnimDuration() {
        return this.startAnimDuration;
    }

    public StripedProcessButton setStartAnimDuration(long startAnimDuration) {
        this.startAnimDuration = startAnimDuration;
        this.invalidate();
        return this;
    }

    public long getStopAnimDuration() {
        return this.stopAnimDuration;
    }

    public StripedProcessButton setStopAnimDuration(long stopAnimDuration) {
        this.stopAnimDuration = stopAnimDuration;
        this.invalidate();
        return this;
    }

    public String getLoadingText() {
        return this.stripedDrawable.getLoadingText();
    }

    public StripedProcessButton setLoadingText(String loadingText) {
        this.stripedDrawable.setLoadingText(loadingText);
        this.invalidate();
        return this;
    }

    public boolean isButtonAnimated() {
        return this.buttonAnimated;
    }

    public StripedProcessButton setButtonAnimated(boolean buttonAnimated) {
        this.buttonAnimated = buttonAnimated;
        this.invalidate();
        return this;
    }

    public float getStripeWidth() {
        return this.stripedDrawable.getStripeWidth();
    }

    public StripedProcessButton setStripeWidth(float stripeWidth) {
        this.stripedDrawable.setStripeWidth(stripeWidth * this.density);
        this.invalidate();
        return this;
    }

    public int getColorBack() {
        return this.stripedDrawable.getColorBack();
    }

    public StripedProcessButton setColorBack(int colorBack) {
        this.stripedDrawable.setColorBack(colorBack);
        this.invalidate();
        return this;
    }

    public int getColorMain() {
        return this.stripedDrawable.getColorMain();
    }

    public StripedProcessButton setColorMain(int colorMain) {
        this.stripedDrawable.setColorMain(colorMain);
        this.invalidate();
        return this;
    }

    public int getColorSub() {
        return this.stripedDrawable.getColorSub();
    }

    public StripedProcessButton setColorSub(int colorSub) {
        this.stripedDrawable.setColorSub(colorSub);
        this.invalidate();
        return this;
    }

    public float getStripeAlpha() {
        return this.stripedDrawable.getStripeAlpha();
    }

    public StripedProcessButton setStripeAlpha(float alpha) {
        this.stripedDrawable.setStripeAlpha(alpha);
        this.invalidate();
        return this;
    }

    public float getCornerRadius() {
        return this.stripedDrawable.getCornerRadius();
    }

    public StripedProcessButton setCornerRadius(float cornerRadius) {
        this.stripedDrawable.setCornerRadius(cornerRadius);
        this.invalidate();
        return this;
    }

    public int getStripeDuration() {
        return this.stripedDrawable.getStripeDuration();
    }

    public StripedProcessButton setStripeDuration(int stripeDuration) {
        this.stripedDrawable.setStripeDuration(stripeDuration);
        this.invalidate();
        return this;
    }

    public float getTilt() {
        return this.stripedDrawable.getTilt();
    }

    public StripedProcessButton setTilt(float tilt) {
        this.stripedDrawable.setTilt(tilt);
        this.invalidate();
        return this;
    }

    public boolean isStripeRevert() {
        return this.stripedDrawable.isStripeRevert();
    }

    public StripedProcessButton setStripeRevert(boolean stripeRevert) {
        this.stripedDrawable.setStripeRevert(stripeRevert);
        this.invalidate();
        return this;
    }

    public boolean isShowStripes() {
        return this.stripedDrawable.isShowStripes();
    }

    public StripedProcessButton setShowStripes(boolean showStripes) {
        this.stripedDrawable.setShowStripes(showStripes);
        this.invalidate();
        return this;
    }

    public boolean isStripeGradient() {
        return this.stripedDrawable.isStripeGradient();
    }

    public StripedProcessButton setStripeGradient(boolean stripeGradient) {
        this.stripedDrawable.setStripeGradient(stripeGradient);
        this.invalidate();
        return this;
    }

    private static enum State {
        START,
        STOP;

    }
}

