/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.github.nikartm.support.AnimatedStripedDrawable;
import com.github.nikartm.support.R;
import com.github.nikartm.support.constant.Constants;

class AttributeController {
    private AnimatedStripedDrawable drawable;
    private String loadingText;

    public AttributeController(Context context, AttributeSet attrs) {
        this.drawable = new AnimatedStripedDrawable(context);
        this.initAttrs(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StripedProcessButton);
        try {
            float stripeWidth = typedArray.getDimension(R.styleable.StripedProcessButton_spb_stripeWidth, 13.0f);
            float stripeAlpha = typedArray.getFloat(R.styleable.StripedProcessButton_spb_stripeAlpha, 0.3f);
            int stripeTilt = typedArray.getInt(R.styleable.StripedProcessButton_spb_stripeTilt, 40);
            int stripeDuration = typedArray.getInt(R.styleable.StripedProcessButton_spb_stripeDuration, 250);
            int background = typedArray.getColor(R.styleable.StripedProcessButton_spb_background, Constants.DEF_BACKGROUND);
            int mainStripeColor = typedArray.getColor(R.styleable.StripedProcessButton_spb_mainStripColor, Constants.DEF_MAIN_STRIPE);
            int subStripeColor = typedArray.getColor(R.styleable.StripedProcessButton_spb_subStripeColor, Constants.DEF_SUB_STRIPE);
            float cornerRadius = typedArray.getFloat(R.styleable.StripedProcessButton_spb_cornerRadius, 25.0f);
            boolean stripeRevert = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_stripeRevert, false);
            boolean showStripes = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_showStripes, true);
            boolean stripeGradient = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_stripeGradient, true);
            this.loadingText = typedArray.getString(R.styleable.StripedProcessButton_spb_loadingText);
            this.drawable.setStripeWidth(stripeWidth).setStripeAlpha(stripeAlpha).setTilt(stripeTilt).setStripeDuration(stripeDuration).setColorBack(background).setColorMain(mainStripeColor).setColorSub(subStripeColor).setCornerRadius(cornerRadius).setStripeRevert(stripeRevert).setShowStripes(showStripes).setStripeGradient(stripeGradient);
        }
        finally {
            typedArray.recycle();
        }
    }

    public AnimatedStripedDrawable getStripedDrawable() {
        return this.drawable;
    }

    public String getLoadingText() {
        return this.loadingText;
    }
}

