/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.nikartm.support.Util;

public class AnimatedStripedDrawable
extends Drawable {
    private float stripeWidth;
    private int colorBack;
    private int colorMain;
    private int colorSub;
    private float alpha;
    private float cornerRadius;
    private int stripeDuration;
    private float tilt;
    private boolean stripeRevert;
    private boolean showStripes;
    private boolean stripeGradient;
    private float density;
    private int viewHeight;
    private int viewWidth;
    private float tiltLeft = 0.0f;
    private float tiltRight = 0.0f;
    private boolean running = false;
    private Context context;
    private ValueAnimator animator;
    private Shader stripesShader;

    public AnimatedStripedDrawable(Context context) {
        this.context = context;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.density = this.context.getResources().getDisplayMetrics().density;
        this.viewHeight = bounds.height();
        this.viewWidth = bounds.width();
        this.adjustStripes();
        this.initAnimator();
    }

    private void adjustStripes() {
        this.stripeWidth *= this.density;
        if (!this.stripeRevert) {
            this.tiltLeft = this.tilt / this.density;
            this.tiltRight = 0.0f;
        } else {
            this.tiltRight = this.tilt / this.density;
            this.tiltLeft = 0.0f;
        }
    }

    private void initAnimator() {
        if (this.animator == null) {
            this.animator = ValueAnimator.ofInt((int[])new int[]{0, 1});
            this.animator.setRepeatCount(-1);
            this.animator.setDuration((long)this.stripeDuration);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    AnimatedStripedDrawable.this.shiftColor(AnimatedStripedDrawable.this.colorMain, AnimatedStripedDrawable.this.colorSub);
                    AnimatedStripedDrawable.this.invalidateSelf();
                }
            });
        }
    }

    public int getIntrinsicWidth() {
        return this.viewWidth > 0 ? this.viewWidth : super.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.viewHeight > 0 ? this.viewHeight : super.getIntrinsicHeight();
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        this.drawStripes(canvas);
        this.startStripesAnimation();
    }

    private void startStripesAnimation() {
        if (this.running) {
            this.start();
        } else {
            this.setShowStripes(false);
        }
    }

    private void drawStripes(Canvas canvas) {
        Paint paintBack = new Paint(1);
        Paint paintStripes = new Paint(1);
        Rect rect = new Rect(0, 0, this.viewWidth, this.viewHeight);
        RectF rectF = new RectF(rect);
        int stripesAlpha = Util.computeAlpha(this.alpha);
        this.stripesShader = this.stripeGradient ? this.createGradientShader() : this.createShader();
        paintBack.setColor(this.colorBack);
        canvas.drawRoundRect(rectF, this.cornerRadius, this.cornerRadius, paintBack);
        if (this.showStripes) {
            paintStripes.setAlpha(stripesAlpha);
            paintStripes.setShader(this.stripesShader);
            canvas.drawRoundRect(rectF, this.cornerRadius, this.cornerRadius, paintStripes);
        }
    }

    @NonNull
    private LinearGradient createShader() {
        return new LinearGradient(this.stripeWidth, this.tiltLeft, 0.0f, this.tiltRight, new int[]{this.colorMain, this.colorSub}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
    }

    @NonNull
    private LinearGradient createGradientShader() {
        return new LinearGradient(this.stripeWidth, this.tiltLeft, 0.0f, this.tiltRight, this.colorMain, this.colorSub, Shader.TileMode.REPEAT);
    }

    private void shiftColor(int mainColor, int subColor) {
        this.colorMain = subColor;
        this.colorSub = mainColor;
    }

    protected void start() {
        if (this.isRunning()) {
            return;
        }
        this.running = true;
        this.initAnimator();
        this.animator.start();
        this.setShowStripes(true);
        this.invalidateSelf();
    }

    protected void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.running = false;
        this.animator.cancel();
        this.setShowStripes(false);
        this.invalidateSelf();
    }

    protected boolean isRunning() {
        return this.animator != null && this.animator.isStarted();
    }

    public float getStripeWidth() {
        return this.stripeWidth;
    }

    public AnimatedStripedDrawable setStripeWidth(float stripeWidth) {
        this.stripeWidth = stripeWidth;
        this.invalidateSelf();
        return this;
    }

    public int getColorBack() {
        return this.colorBack;
    }

    public AnimatedStripedDrawable setColorBack(int colorBack) {
        this.colorBack = colorBack;
        this.invalidateSelf();
        return this;
    }

    public int getColorMain() {
        return this.colorMain;
    }

    public AnimatedStripedDrawable setColorMain(int colorMain) {
        this.colorMain = colorMain;
        this.invalidateSelf();
        return this;
    }

    public int getColorSub() {
        return this.colorSub;
    }

    public AnimatedStripedDrawable setColorSub(int colorSub) {
        this.colorSub = colorSub;
        this.invalidateSelf();
        return this;
    }

    public float getStripeAlpha() {
        return this.alpha;
    }

    public AnimatedStripedDrawable setStripeAlpha(float alpha) {
        this.alpha = alpha;
        this.invalidateSelf();
        return this;
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public AnimatedStripedDrawable setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
        this.invalidateSelf();
        return this;
    }

    public int getStripeDuration() {
        return this.stripeDuration;
    }

    public AnimatedStripedDrawable setStripeDuration(int stripeDuration) {
        this.stripeDuration = stripeDuration;
        this.invalidateSelf();
        return this;
    }

    public float getTilt() {
        return this.tilt;
    }

    public AnimatedStripedDrawable setTilt(float tilt) {
        this.tilt = tilt;
        this.invalidateSelf();
        return this;
    }

    public boolean isStripeRevert() {
        return this.stripeRevert;
    }

    public AnimatedStripedDrawable setStripeRevert(boolean stripeRevert) {
        this.stripeRevert = stripeRevert;
        this.invalidateSelf();
        return this;
    }

    public boolean isShowStripes() {
        return this.showStripes;
    }

    public AnimatedStripedDrawable setShowStripes(boolean showStripes) {
        this.showStripes = showStripes;
        this.invalidateSelf();
        return this;
    }

    public boolean isStripeGradient() {
        return this.stripeGradient;
    }

    public AnimatedStripedDrawable setStripeGradient(boolean stripeGradient) {
        this.stripeGradient = stripeGradient;
        this.invalidateSelf();
        return this;
    }
}

