/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.view.View;
import ru.nikartm.support.model.Badge;

public class BadgePosition {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int CENTER = 4;
    private View view;
    private Badge badge;
    private boolean isDrawBackgroundAdded = false;
    private float pivotX;
    private float pivotY;
    private int viewHeight;
    private int viewWidth;
    private int badgeWidth;
    private int badgeHeight;
    private float deltaX;
    private float deltaY;

    BadgePosition(View view, Badge badge) {
        this.view = view;
        this.badge = badge;
        this.init();
        this.computeBadgeWidth();
        this.computeBadgeHeight();
        this.computeRadius();
    }

    private void init() {
        this.isDrawBackgroundAdded = this.badge.getBackgroundDrawable() != null;
        this.pivotX = this.view.getPivotX();
        this.pivotY = this.view.getPivotY();
        this.viewHeight = this.view.getMeasuredHeight();
        this.viewWidth = this.view.getMeasuredWidth();
    }

    public BadgePosition compute() {
        switch (this.badge.getPosition()) {
            case 0: {
                this.computeTopLeft();
                break;
            }
            case 1: {
                this.computeTopRight();
                break;
            }
            case 2: {
                this.computeBottomLeft();
                break;
            }
            case 3: {
                this.computeBottomRight();
                break;
            }
            case 4: {
                this.computeCenter();
            }
        }
        return this;
    }

    private void defineMeasurement() {
        if (this.checkFixedRadius()) {
            int maxMeasurement;
            this.badgeWidth = maxMeasurement = Math.max(this.badgeWidth, this.badgeHeight);
            this.badgeHeight = maxMeasurement;
        } else if (this.badge.isOvalAfterFirst() && this.badge.getValue() <= 9 || this.badge.isRoundBadge() && this.badgeWidth < this.badgeHeight) {
            this.badgeWidth = this.badgeHeight;
        }
    }

    private void computeTopLeft() {
        if (this.isDrawBackgroundAdded) {
            this.defineMeasurement();
            this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.badgeWidth / 2);
            this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.badgeHeight / 2);
        } else {
            this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + this.badge.getRadius();
            this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + this.badge.getRadius();
        }
    }

    private void computeTopRight() {
        if (this.isDrawBackgroundAdded) {
            this.defineMeasurement();
            this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.badgeWidth / 2);
            this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + (float)(this.badgeHeight / 2);
        } else {
            this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - this.badge.getRadius();
            this.deltaY = this.pivotY - (float)(this.viewHeight / 2) + this.badge.getRadius();
        }
    }

    private void computeBottomLeft() {
        if (this.isDrawBackgroundAdded) {
            this.defineMeasurement();
            this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + (float)(this.badgeWidth / 2);
            this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.badgeHeight / 2);
        } else {
            this.deltaX = this.pivotX - (float)(this.viewWidth / 2) + this.badge.getRadius();
            this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - this.badge.getRadius();
        }
    }

    private void computeBottomRight() {
        if (this.isDrawBackgroundAdded) {
            this.defineMeasurement();
            this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - (float)(this.badgeWidth / 2);
            this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - (float)(this.badgeHeight / 2);
        } else {
            this.deltaX = this.pivotX + (float)(this.viewWidth / 2) - this.badge.getRadius();
            this.deltaY = this.pivotY + (float)(this.viewHeight / 2) - this.badge.getRadius();
        }
    }

    private void computeCenter() {
        this.deltaX = this.viewWidth / 2;
        this.deltaY = this.viewHeight / 2;
        if (this.isDrawBackgroundAdded) {
            this.defineMeasurement();
        }
    }

    private void computeBadgeWidth() {
        this.badgeWidth = this.badge.getFixedRadiusSize() != -1.0f ? (int)(this.badge.getFixedRadiusSize() * 2.0f) : (this.isDrawBackgroundAdded && this.badge.getValue() > 9 && this.badge.isOvalAfterFirst() && !this.badge.isFixedRadius() ? (int)(this.badge.getTextWidth() + this.badge.getPadding() * 4.0f) : (int)(this.badge.getTextWidth() + this.badge.getPadding() * 2.0f));
    }

    private void computeBadgeHeight() {
        this.badgeHeight = this.badge.getFixedRadiusSize() != -1.0f ? (int)(this.badge.getFixedRadiusSize() * 2.0f) : (int)(this.badge.getBadgeTextSize() + this.badge.getPadding() * 2.0f);
    }

    private void computeRadius() {
        if (this.badge.getFixedRadiusSize() != -1.0f) {
            this.badge.setRadius(this.badge.getFixedRadiusSize());
        } else {
            this.badge.setRadius((float)this.badgeWidth / 2.0f);
        }
    }

    private boolean checkFixedRadius() {
        return this.badge.getFixedRadiusSize() != -1.0f || this.badge.isFixedRadius();
    }

    public int getBadgeHeight() {
        return this.badgeHeight;
    }

    public int getBadgeWidth() {
        return this.badgeWidth;
    }

    public float getDeltaX() {
        return this.deltaX;
    }

    public float getDeltaY() {
        return this.deltaY;
    }
}

