/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import ru.nikartm.support.R;
import ru.nikartm.support.constant.Constants;
import ru.nikartm.support.model.Badge;
import ru.nikartm.support.util.DensityUtils;

public class AttributeController {
    private View view;
    private AttributeSet attrs;
    private Badge badge;

    public AttributeController(View view, AttributeSet attrs) {
        this.view = view;
        this.attrs = attrs;
        this.badge = new Badge();
        this.initAttr();
    }

    private void initAttr() {
        TypedArray typedArray = this.view.getContext().obtainStyledAttributes(this.attrs, R.styleable.ImageBadgeView);
        int value = typedArray.getInt(R.styleable.ImageBadgeView_ibv_badgeValue, 0);
        int maxBadgeValue = typedArray.getInt(R.styleable.ImageBadgeView_ibv_maxBadgeValue, 99);
        float textSize = typedArray.getDimension(R.styleable.ImageBadgeView_ibv_badgeTextSize, DensityUtils.txtPxToSp(12.0f));
        float padding = typedArray.getDimension(R.styleable.ImageBadgeView_ibv_badgePadding, DensityUtils.pxToDp(0.0f));
        float fixedBadgeRadius = typedArray.getDimension(R.styleable.ImageBadgeView_ibv_fixedBadgeRadius, DensityUtils.pxToDp(-1.0f));
        int badgeTextStyle = typedArray.getInt(R.styleable.ImageBadgeView_ibv_badgeTextStyle, 0);
        String fontPath = typedArray.getString(R.styleable.ImageBadgeView_ibv_badgeTextFont);
        Typeface badgeTextFont = fontPath != null ? Typeface.createFromFile((String)fontPath) : Constants.DEFAULT_FONT;
        Drawable badgeDrawable = typedArray.getDrawable(R.styleable.ImageBadgeView_ibv_badgeBackground);
        boolean visible = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_visibleBadge, false);
        boolean limitValue = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_badgeLimitValue, true);
        boolean roundBadge = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_roundBadge, true);
        boolean fixedRadius = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_fixedRadius, false);
        boolean ovalAfterFirst = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_badgeOvalAfterFirst, false);
        boolean showCounter = typedArray.getBoolean(R.styleable.ImageBadgeView_ibv_showCounter, true);
        int badgeColor = typedArray.getColor(R.styleable.ImageBadgeView_ibv_badgeColor, Constants.DEFAULT_BADGE_COLOR);
        int badgeTextColor = typedArray.getColor(R.styleable.ImageBadgeView_ibv_badgeTextColor, -1);
        int badgePosition = typedArray.getInt(R.styleable.ImageBadgeView_ibv_badgePosition, 1);
        this.badge.setValue(value).setMaxValue(maxBadgeValue).setBadgeTextSize(textSize).setPadding(padding).setFixedRadiusSize(fixedBadgeRadius).setTextStyle(badgeTextStyle).setBadgeTextFont(badgeTextFont).setBackgroundDrawable(badgeDrawable).setVisible(visible).setLimitValue(limitValue).setRoundBadge(roundBadge).setFixedRadius(fixedRadius).setOvalAfterFirst(ovalAfterFirst).setShowCounter(showCounter).setBadgeColor(badgeColor).setBadgeTextColor(badgeTextColor).setPosition(badgePosition);
        typedArray.recycle();
    }

    public Badge getBadge() {
        return this.badge;
    }
}

