/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format.awt;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.jglfont.impl.format.JGLAbstractFontData;
import org.jglfont.impl.format.JGLAwtFontData;
import org.jglfont.impl.format.JGLFontLoader;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class AwtJGLFontLoader
implements JGLFontLoader {
    private static final Logger log = Logger.getLogger(AwtJGLFontLoader.class.getName());

    @Override
    public JGLAbstractFontData load(JGLFontRenderer renderer, ResourceLoader resourceLoader, InputStream in, String filename, int size, int style, String params) throws IOException {
        String[] pairs;
        Font font;
        if (in != null) {
            try {
                font = Font.createFont(0, in);
            }
            catch (FontFormatException e) {
                throw new IOException(e);
            }
        } else {
            font = Font.decode(filename);
        }
        int glyphSide = 256;
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        for (String pair : pairs = params.split(";")) {
            String[] keyvalue = pair.split("=");
            if (keyvalue.length != 2 || !keyvalue[0].equalsIgnoreCase("glyphSide")) continue;
            try {
                glyphSide = Integer.parseInt(keyvalue[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (in != null) {
            Map<TextAttribute, ?> attributes = font.getAttributes();
            attributes.put(TextAttribute.SIZE, size);
            attributes.put(TextAttribute.WEIGHT, bold ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            attributes.put(TextAttribute.POSTURE, italic ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            font = font.deriveFont(attributes);
        }
        log.fine("Font loaded: " + font.toString());
        JGLAwtFontData data = new JGLAwtFontData(renderer, resourceLoader, font, glyphSide);
        ((JGLAbstractFontData)data).init();
        return data;
    }
}

