/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format.angelcode;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.jglfont.impl.format.angelcode.AngelCodeLineData;

public class AngelCodeLineParser {
    private StreamTokenizer tokenizer;
    private String currentKey;
    private boolean hasValue;
    private int token;

    public void parse(String source, AngelCodeLineData parsed) throws IOException {
        this.tokenizer = this.createTokenizer(source);
        this.currentKey = "";
        this.hasValue = false;
        parsed.clear();
        while ((this.token = this.tokenizer.nextToken()) != -1) {
            this.processToken(parsed);
        }
    }

    private void processToken(AngelCodeLineData parsed) {
        switch (this.token) {
            case -3: {
                this.processWord(parsed);
                break;
            }
            case 61: {
                this.hasValue = true;
                break;
            }
            case 34: {
                if (this.currentKey.length() <= 0) break;
                parsed.put(this.currentKey, this.tokenizer.sval);
                this.currentKey = "";
            }
        }
    }

    private void processWord(AngelCodeLineData parsed) {
        if (this.currentKey.length() == 0) {
            this.currentKey = this.tokenizer.sval;
        } else if (this.hasValue) {
            parsed.put(this.currentKey, this.tokenizer.sval);
            this.currentKey = "";
        } else {
            parsed.put(this.currentKey, "");
            this.currentKey = this.tokenizer.sval;
        }
    }

    private StreamTokenizer createTokenizer(String source) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(source));
        this.initializeTokenizer(tokenizer);
        return tokenizer;
    }

    private void initializeTokenizer(StreamTokenizer tokenizer) {
        tokenizer.whitespaceChars(32, 32);
        tokenizer.quoteChar(34);
        tokenizer.ordinaryChars(48, 57);
        tokenizer.wordChars(48, 57);
        tokenizer.ordinaryChar(46);
        tokenizer.wordChars(46, 46);
        tokenizer.ordinaryChar(44);
        tokenizer.wordChars(44, 44);
        tokenizer.ordinaryChar(45);
        tokenizer.wordChars(45, 45);
    }
}

