/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format.angelcode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jglfont.impl.format.JGLAbstractFontData;
import org.jglfont.impl.format.JGLBitmapFontData;
import org.jglfont.impl.format.JGLFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeLine;
import org.jglfont.impl.format.angelcode.AngelCodeLineData;
import org.jglfont.impl.format.angelcode.AngelCodeLineParser;
import org.jglfont.impl.format.angelcode.AngelCodeLineProcessors;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class AngelCodeJGLFontLoader
implements JGLFontLoader {
    private static final Logger log = Logger.getLogger(AngelCodeJGLFontLoader.class.getName());
    private final AngelCodeLineParser parser = new AngelCodeLineParser();
    private final AngelCodeLineData parsed = new AngelCodeLineData();
    private final AngelCodeLineProcessors lineProcessors;

    public AngelCodeJGLFontLoader(AngelCodeLineProcessors lineProcessors) {
        this.lineProcessors = lineProcessors;
    }

    @Override
    public JGLAbstractFontData load(JGLFontRenderer renderer, ResourceLoader resourceLoader, InputStream in, String filename, int size, int style, String params) throws IOException {
        JGLBitmapFontData result = new JGLBitmapFontData(renderer, resourceLoader, filename);
        this.load(in, result);
        ((JGLAbstractFontData)result).init();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream in, JGLAbstractFontData bitmapFont) throws IOException {
        if (in == null) {
            throw new IOException("InputStream is null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split[0].length() == 0) {
                    break;
                }
                this.parser.parse(line, this.parsed);
                AngelCodeLine processor = this.lineProcessors.get(split[0]);
                if (processor == null || processor.process(this.parsed, bitmapFont)) continue;
                log.warning("parsing error for line [" + line + "] using " + processor + " with " + this.parsed);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error while parsing font file: ", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

