/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format;

import java.io.IOException;
import java.util.Map;
import org.jglfont.JGLFontException;
import org.jglfont.impl.format.JGLAbstractFontData;
import org.jglfont.impl.format.JGLFontGlyphInfo;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class JGLBitmapFontData
extends JGLAbstractFontData {
    private String filename;

    public JGLBitmapFontData(JGLFontRenderer renderer, ResourceLoader resourceLoader, String filename) {
        super(renderer, resourceLoader);
        this.filename = filename;
    }

    @Override
    public void init() {
        this.initalize(this.extractPath(this.filename));
    }

    private void initalize(String path) {
        for (Map.Entry<Integer, String> entry : this.getBitmaps().entrySet()) {
            try {
                String filename = path + entry.getValue();
                this.getRenderer().registerBitmap(this.bitmapKey(entry.getKey()), this.resourceLoader.load(filename), filename);
            }
            catch (IOException e) {
                throw new JGLFontException(e);
            }
        }
        this.initGlyphs();
        this.getRenderer().prepare();
    }

    private String extractPath(String filename) {
        int idx = filename.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return filename.substring(0, idx) + "/";
    }

    private void initGlyphs() {
        for (Map.Entry<Integer, JGLFontGlyphInfo> entry : this.getGlyphs().entrySet()) {
            Integer c = entry.getKey();
            JGLFontGlyphInfo charInfo = entry.getValue();
            if (charInfo == null) continue;
            this.getRenderer().registerGlyph(charInfo.getPage(), c, charInfo.getXoffset(), charInfo.getYoffset(), charInfo.getWidth(), charInfo.getHeight(), (float)charInfo.getX() / (float)this.getBitmapWidth(), (float)charInfo.getY() / (float)this.getBitmapHeight(), (float)(charInfo.getX() + charInfo.getWidth()) / (float)this.getBitmapWidth(), (float)(charInfo.getY() + charInfo.getHeight()) / (float)this.getBitmapHeight());
        }
    }

    private String bitmapKey(int key) {
        return this.getName() + "-" + key;
    }
}

