/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl;

import org.jglfont.JGLFont;
import org.jglfont.impl.format.JGLAbstractFontData;
import org.jglfont.impl.format.JGLFontGlyphInfo;

public class JGLFontImpl
implements JGLFont {
    private final JGLAbstractFontData fontData;
    private Object customRenderState;

    public JGLFontImpl(JGLAbstractFontData fontData) {
        this.fontData = fontData;
    }

    @Override
    public void renderText(int x, int y, String text) {
        this.renderText(x, y, text, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderText(int x, int y, String text, float sizeX, float sizeY, float r, float g, float b, float a) {
        int currentCodepoint;
        if (text.length() == 0) {
            return;
        }
        int xPos = x;
        int yPos = y;
        this.fontData.getRenderer().beforeRender(this.customRenderState);
        for (int offset = 0; offset < text.length() && (offset = this.fontData.getRenderer().preProcess(text, offset)) < text.length(); offset += Character.charCount(currentCodepoint)) {
            currentCodepoint = text.codePointAt(offset);
            int nextCodePoint = this.getNextCodepoint(text, offset);
            JGLFontGlyphInfo characterInfo = this.fontData.getGlyphs().get(currentCodepoint);
            if (characterInfo == null) continue;
            this.fontData.getRenderer().render(characterInfo.getPage(), xPos, yPos, currentCodepoint, sizeX, sizeY, r, g, b, a);
            xPos = (int)((float)xPos + (float)this.getCharacterWidth(currentCodepoint, nextCodePoint, sizeX));
        }
        this.fontData.getRenderer().afterRender();
    }

    @Override
    public int getCharacterWidth(int currentCharacter, int nextCharacter) {
        return this.getCharacterWidth(currentCharacter, nextCharacter, 1.0f);
    }

    @Override
    public int getCharacterWidth(int currentCharacter, int nextCharacter, float size) {
        JGLFontGlyphInfo currentCharacterInfo = this.fontData.getGlyphs().get(currentCharacter);
        if (currentCharacterInfo == null) {
            return 0;
        }
        return (int)((float)(currentCharacterInfo.getXadvance() + this.getKerning(currentCharacterInfo, nextCharacter)) * size);
    }

    @Override
    public int getStringWidth(String text) {
        return this.getStringWidth(text, 1.0f);
    }

    @Override
    public int getStringWidth(String text, float size) {
        int length = 0;
        int offset = 0;
        while (offset < text.length() && (offset = this.fontData.getRenderer().preProcessForLength(text, offset)) < text.length()) {
            int currentCodepoint = text.codePointAt(offset);
            int nextCodepoint = this.getNextCodepoint(text, offset);
            offset += Character.charCount(currentCodepoint);
            int w = this.getCharacterWidth(currentCodepoint, nextCodepoint, size);
            if (w == -1) continue;
            length += w;
        }
        return length;
    }

    @Override
    public int getHeight() {
        return this.fontData.getLineHeight();
    }

    @Override
    public void setCustomRenderState(Object o) {
        this.customRenderState = o;
    }

    private int getNextCodepoint(String text, int currentIndex) {
        int nextCodepoint = 0;
        if (currentIndex < text.length() - 1) {
            int currentCodepoint = text.codePointAt(currentIndex);
            nextCodepoint = text.codePointAt(currentIndex + Character.charCount(currentCodepoint));
        }
        return nextCodepoint;
    }

    private int getKerning(JGLFontGlyphInfo currentCharacterInfo, int nextCharacter) {
        Integer kern = currentCharacterInfo.getKerning().get(nextCharacter);
        if (kern != null) {
            return kern;
        }
        return 0;
    }
}

