/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.VetoTopicEventListener;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class ProxyTopicSubscriber
extends AbstractProxySubscriber
implements EventTopicSubscriber,
VetoTopicEventListener {
    private String topic;

    public ProxyTopicSubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, EventService es, String topic, boolean veto) {
        this(proxiedSubscriber, subscriptionMethod, referenceStrength, 0, es, topic, veto);
    }

    public ProxyTopicSubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, int priority, EventService es, String topic, boolean veto) {
        super(proxiedSubscriber, subscriptionMethod, referenceStrength, priority, es, veto);
        this.topic = topic;
        if (topic == null) {
            throw new IllegalArgumentException("Proxies for topic subscribers require a non-null topic.");
        }
        Class<?>[] params = subscriptionMethod.getParameterTypes();
        if (params == null || params.length != 2 || !String.class.equals(params[0]) || params[1].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
    }

    public void onEvent(String topic, Object data) {
        Object[] args = new Object[]{topic, data};
        Object obj = null;
        Method subscriptionMethod = null;
        try {
            obj = this.getProxiedSubscriber();
            if (obj == null) {
                return;
            }
            subscriptionMethod = this.getSubscriptionMethod();
            subscriptionMethod.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            String message = "IllegalAccessException when invoking annotated method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod();
            this.retryReflectiveCallUsingAccessibleObject(args, subscriptionMethod, obj, e, message);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException when invoking annotated method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), e);
        }
    }

    public boolean shouldVeto(String topic, Object data) {
        Object[] args = new Object[]{topic, data};
        Object obj = null;
        Method subscriptionMethod = null;
        try {
            obj = this.getProxiedSubscriber();
            if (obj == null) {
                return false;
            }
            subscriptionMethod = this.getSubscriptionMethod();
            return Boolean.valueOf(subscriptionMethod.invoke(obj, args) + "");
        }
        catch (IllegalAccessException e) {
            String message = "IllegalAccessException when invoking annotated veto method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod();
            return this.retryReflectiveCallUsingAccessibleObject(args, subscriptionMethod, obj, e, message);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException when invoking annotated veto method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), e);
        }
    }

    protected void unsubscribe(String topic) {
        if (this.veto) {
            this.getEventService().unsubscribeVetoListener(topic, (VetoTopicEventListener)this);
        } else {
            this.getEventService().unsubscribe(topic, (EventTopicSubscriber)this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProxyTopicSubscriber) {
            if (!super.equals(obj)) {
                return false;
            }
            ProxyTopicSubscriber proxyTopicSubscriber = (ProxyTopicSubscriber)obj;
            if (this.topic.equals(proxyTopicSubscriber.topic)) {
                if (this.topic == null) {
                    return false;
                }
                if (!this.topic.equals(proxyTopicSubscriber.topic)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ProxyTopicSubscriber{topic='" + this.topic + '\'' + "veto='" + this.veto + '\'' + "realSubscriber=" + this.getProxiedSubscriber() + ", subscriptionMethod=" + this.getSubscriptionMethod() + ", referenceStrength=" + (Object)((Object)this.getReferenceStrength()) + ", eventService=" + this.getEventService() + '}';
    }
}

