/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.resourceloader;

import de.lessvoid.nifty.tools.resourceloader.ResourceLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class FileSystemLocation
implements ResourceLocation {
    @Nonnull
    private final File root;

    public FileSystemLocation(@Nonnull File root) {
        this.root = root;
    }

    @Override
    @Nullable
    public URL getResource(@Nonnull String ref) {
        try {
            File file = new File(this.root, ref);
            if (!file.exists()) {
                file = new File(ref);
            }
            if (!file.exists()) {
                return null;
            }
            return file.toURI().toURL();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @Nullable
    @WillNotClose
    public InputStream getResourceAsStream(@Nonnull String ref) {
        try {
            File file = new File(this.root, ref);
            if (!file.exists()) {
                file = new File(ref);
            }
            return new FileInputStream(file);
        }
        catch (IOException e) {
            return null;
        }
    }
}

