/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.pulsate;

import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.pulsate.PulsatorProvider;
import de.lessvoid.nifty.tools.pulsate.provider.NullPulsator;
import de.lessvoid.nifty.tools.pulsate.provider.RectanglePulsator;
import de.lessvoid.nifty.tools.pulsate.provider.SinusPulsator;
import de.lessvoid.nifty.tools.pulsate.provider.SinusRaisedPulsator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class Pulsator {
    @Nonnull
    private static final Logger log = Logger.getLogger(Pulsator.class.getName());
    @Nonnull
    private final TimeProvider timeProvider;
    @Nonnull
    private final PulsatorProvider pulsateProvider;

    public Pulsator(@Nonnull Properties parameter, @Nonnull TimeProvider newTimeProvider) {
        this.timeProvider = newTimeProvider;
        String pulsateType = parameter.getProperty("pulsateType", "sin");
        if ("sin".equals(pulsateType)) {
            this.pulsateProvider = new SinusPulsator();
        } else if ("sinRaised".equals(pulsateType)) {
            this.pulsateProvider = new SinusRaisedPulsator();
        } else if ("rectangle".equals(pulsateType)) {
            this.pulsateProvider = new RectanglePulsator();
        } else {
            log.warning(pulsateType + " is not supported, using NullPulsator for fallback. probably not what you want...");
            this.pulsateProvider = new NullPulsator();
        }
        this.pulsateProvider.initialize(parameter);
        this.reset();
    }

    public void reset() {
        this.pulsateProvider.reset(this.timeProvider.getMsTime());
    }

    public float update() {
        return this.pulsateProvider.getValue(this.timeProvider.getMsTime());
    }
}

