/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import java.util.ArrayList;
import javax.annotation.Nonnull;

public class LinearInterpolator {
    @Nonnull
    private final ArrayList<Point> curve = new ArrayList();
    private float maxX = 0.0f;

    public void addPoint(float x, float y) {
        this.curve.add(new Point(x, y));
    }

    public void prepare() {
        this.maxX = this.calcMaxX(this.curve);
        for (Point p : this.curve) {
            p.x /= this.maxX;
        }
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getValue(float x) {
        Point p0 = this.curve.get(0);
        for (int i = 1; i < this.curve.size(); ++i) {
            Point p1 = this.curve.get(i);
            if (this.isInInterval(x, p0, p1)) {
                return this.calcValue(x, p0, p1);
            }
            p0 = p1;
        }
        if (x > this.curve.get((int)(this.curve.size() - 1)).x) {
            return this.curve.get((int)(this.curve.size() - 1)).y;
        }
        if (x < this.curve.get((int)0).x) {
            return this.curve.get((int)0).y;
        }
        return 0.0f;
    }

    private boolean isInInterval(float x, @Nonnull Point p0, @Nonnull Point p1) {
        return x >= p0.x && x <= p1.x;
    }

    private float calcValue(float x, @Nonnull Point p0, @Nonnull Point p1) {
        float st = (x - p0.x) / (p1.x - p0.x);
        return p0.y + st * (p1.y - p0.y);
    }

    private float calcMaxX(@Nonnull ArrayList<Point> curve) {
        float maxX = -1.0f;
        for (Point p : curve) {
            if (!(p.x > maxX)) continue;
            maxX = p.x;
        }
        return maxX;
    }

    public static class Point {
        public float x;
        public final float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

