/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import javax.annotation.Nonnull;

public class Alpha {
    public static final Alpha ZERO = new Alpha(0.0f);
    public static final Alpha FULL = new Alpha(1.0f);
    private static final int SCALE_SHORT_MODE = 17;
    private static final float MAX_INT_VALUE = 255.0f;
    private static final int HEX_BASE = 16;
    private float alpha = 0.0f;

    public Alpha(@Nonnull String color) {
        this.alpha = this.getAFromString(color);
    }

    public Alpha(float newAlpha) {
        this.alpha = newAlpha;
    }

    @Nonnull
    public Alpha linear(@Nonnull Alpha end, float t) {
        return new Alpha(this.alpha + t * (end.alpha - this.alpha));
    }

    public final float getAlpha() {
        return this.alpha;
    }

    private float getAFromString(@Nonnull String color) {
        if (this.isShortMode(color)) {
            return (float)(Integer.valueOf(color.substring(1, 2), 16) * 17) / 255.0f;
        }
        return (float)Integer.valueOf(color.substring(1, 3), 16).intValue() / 255.0f;
    }

    private boolean isShortMode(@Nonnull String color) {
        return color.length() == 2;
    }

    @Deprecated
    @Nonnull
    public Alpha mutiply(float factor) {
        return this.multiply(factor);
    }

    @Nonnull
    public Alpha multiply(float factor) {
        return new Alpha(this.alpha * factor);
    }

    @Nonnull
    public String toString() {
        return "(" + this.alpha + ")";
    }

    public void setAlpha(float newColorAlpha) {
        this.alpha = newColorAlpha;
    }
}

