/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.sound;

import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.spi.sound.SoundHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SoundSystem {
    @Nonnull
    private static final Logger log = Logger.getLogger(SoundSystem.class.getName());
    @Nonnull
    private final SoundDevice soundDevice;
    @Nonnull
    private final Map<String, SoundHandle> soundLookup;
    private float soundVolume;
    private float musicVolume;

    public SoundSystem(@Nonnull SoundDevice newSoundLoader) {
        this.soundDevice = newSoundLoader;
        this.soundVolume = 1.0f;
        this.musicVolume = 1.0f;
        this.soundLookup = new HashMap<String, SoundHandle>();
    }

    public boolean addSound(String name, @Nonnull String filename) {
        log.fine("register sound [" + name + "] for file '" + filename + "'");
        SoundHandle sound = this.soundDevice.loadSound(this, filename);
        if (sound == null) {
            return false;
        }
        this.soundLookup.put(name, sound);
        return true;
    }

    public boolean addMusic(String name, @Nonnull String filename) {
        log.fine("register music [" + name + "] for file '" + filename + "'");
        SoundHandle music = this.soundDevice.loadMusic(this, filename);
        if (music == null) {
            return false;
        }
        this.soundLookup.put(name, music);
        return true;
    }

    @Nullable
    public SoundHandle getSound(@Nullable String name) {
        if (name == null) {
            log.warning("unknown sound name given [null]?");
            return null;
        }
        SoundHandle sound = this.soundLookup.get(name);
        if (sound == null) {
            log.warning("missing sound [" + name + "]");
            return null;
        }
        return sound;
    }

    @Nullable
    public SoundHandle getMusic(@Nullable String name) {
        if (name == null) {
            log.warning("unknown music name given [null]?");
            return null;
        }
        SoundHandle sound = this.soundLookup.get(name);
        if (sound == null) {
            log.warning("missing sound [" + name + "]");
            return null;
        }
        return sound;
    }

    public float getSoundVolume() {
        return this.soundVolume;
    }

    public void setSoundVolume(float newSoundVolume) {
        this.soundVolume = newSoundVolume;
    }

    public float getMusicVolume() {
        return this.musicVolume;
    }

    public void setMusicVolume(float newMusicVolume) {
        this.musicVolume = newMusicVolume;
    }

    public void update(int delta) {
        this.soundDevice.update(delta);
    }
}

