/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.io;

import de.lessvoid.nifty.render.io.ImageLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.imageio.ImageIO;

public class TGAImageLoader
implements ImageLoader {
    private int imageWidth;
    private int imageHeight;
    private short imageBitDepth;
    private int textureWidth;
    private int textureHeight;
    private boolean shouldFlipVertically;
    private boolean shouldForceAlpha;

    @Override
    public int getImageBitDepth() {
        return this.imageBitDepth;
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    @Nonnull
    public ByteBuffer loadAsByteBufferRGBA(@Nonnull @WillNotClose InputStream imageStream) throws IOException {
        return this.loadImage(imageStream, false, true, null);
    }

    @Override
    @Nonnull
    public ByteBuffer loadAsByteBufferARGB(@Nonnull @WillNotClose InputStream imageStream, boolean shouldFlipVertically) throws IOException {
        return this.loadImage(imageStream, shouldFlipVertically, false, null, false, true);
    }

    @Override
    @Nonnull
    public BufferedImage loadAsBufferedImage(@Nonnull @WillNotClose InputStream imageStream) throws IOException {
        return ImageIO.read(imageStream);
    }

    @Nonnull
    private ByteBuffer loadImage(@Nonnull @WillNotClose InputStream imageStream, boolean shouldFlipVertically, boolean shouldForceAlpha, @Nullable int[] transparency) throws IOException {
        int ofs;
        byte red;
        byte green;
        byte blue;
        int j;
        int i;
        byte[] rawData;
        this.shouldFlipVertically = shouldFlipVertically;
        this.shouldForceAlpha = shouldForceAlpha;
        if (transparency != null) {
            this.shouldForceAlpha = true;
        }
        BufferedInputStream bis = new BufferedInputStream(imageStream, 100000);
        DataInputStream dis = new DataInputStream(bis);
        short idLength = (short)dis.read();
        dis.skipBytes(11);
        this.imageWidth = this.flipEndian(dis.readShort());
        this.imageHeight = this.flipEndian(dis.readShort());
        this.imageBitDepth = (short)dis.read();
        if (this.imageBitDepth == 32) {
            this.shouldForceAlpha = false;
        }
        this.textureWidth = this.get2Fold(this.imageWidth);
        this.textureHeight = this.get2Fold(this.imageHeight);
        short imageDescriptor = (short)dis.read();
        if ((imageDescriptor & 0x20) == 0) {
            boolean bl = this.shouldFlipVertically = !this.shouldFlipVertically;
        }
        if (idLength > 0) {
            for (long skipped = 0L; skipped < (long)idLength; skipped += bis.skip(idLength)) {
            }
        }
        if (this.imageBitDepth == 32 || this.shouldForceAlpha) {
            this.imageBitDepth = (short)32;
            rawData = new byte[this.textureWidth * this.textureHeight * 4];
        } else if (this.imageBitDepth == 24) {
            rawData = new byte[this.textureWidth * this.textureHeight * 3];
        } else {
            throw new RuntimeException("Only 24 and 32 bit TGAs are supported");
        }
        if (this.imageBitDepth == 24) {
            if (this.shouldFlipVertically) {
                for (i = this.imageHeight - 1; i >= 0; --i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        ofs = (j + i * this.textureWidth) * 3;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                    }
                }
            } else {
                for (i = 0; i < this.imageHeight; ++i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        ofs = (j + i * this.textureWidth) * 3;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                    }
                }
            }
        } else if (this.imageBitDepth == 32) {
            int alpha;
            if (this.shouldFlipVertically) {
                for (i = this.imageHeight - 1; i >= 0; --i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = this.shouldForceAlpha ? -1 : (int)dis.readByte();
                        ofs = (j + i * this.textureWidth) * 4;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                        rawData[ofs + 3] = alpha;
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            } else {
                for (i = 0; i < this.imageHeight; ++i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = this.shouldForceAlpha ? -1 : (int)dis.readByte();
                        ofs = (j + i * this.textureWidth) * 4;
                        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                            rawData[ofs] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs + 2] = blue;
                            rawData[ofs + 3] = alpha;
                        } else {
                            rawData[ofs] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs + 2] = blue;
                            rawData[ofs + 3] = alpha;
                        }
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            }
        }
        imageStream.close();
        if (transparency != null) {
            for (i = 0; i < rawData.length; i += 4) {
                boolean match = true;
                for (int c = 0; c < 3; ++c) {
                    if (rawData[i + c] == transparency[c]) continue;
                    match = false;
                }
                if (!match) continue;
                rawData[i + 3] = 0;
            }
        }
        ByteBuffer scratch = this.createNativeOrderedByteBuffer(rawData.length);
        scratch.put(rawData);
        int perPixel = this.imageBitDepth / 8;
        if (this.imageHeight < this.textureHeight - 1) {
            int topOffset = (this.textureHeight - 1) * (this.textureWidth * perPixel);
            int bottomOffset = (this.imageHeight - 1) * (this.textureWidth * perPixel);
            for (int x = 0; x < this.textureWidth * perPixel; ++x) {
                scratch.put(topOffset + x, scratch.get(x));
                scratch.put(bottomOffset + this.textureWidth * perPixel + x, scratch.get(this.textureWidth * perPixel + x));
            }
        }
        if (this.imageWidth < this.textureWidth - 1) {
            for (int y = 0; y < this.textureHeight; ++y) {
                for (int i2 = 0; i2 < perPixel; ++i2) {
                    scratch.put((y + 1) * (this.textureWidth * perPixel) - perPixel + i2, scratch.get(y * (this.textureWidth * perPixel) + i2));
                    scratch.put(y * (this.textureWidth * perPixel) + this.imageWidth * perPixel + i2, scratch.get(y * (this.textureWidth * perPixel) + (this.imageWidth - 1) * perPixel + i2));
                }
            }
        }
        scratch.flip();
        return scratch;
    }

    @Nonnull
    private ByteBuffer loadImage(@Nonnull InputStream imageStream, boolean shouldFlipVertically, boolean shouldForceAlpha, @Nullable int[] transparency, boolean forceNonePowerOfTwo, boolean modeARGB) throws IOException {
        int ofs;
        byte red;
        byte green;
        byte blue;
        int j;
        int i;
        byte[] rawData;
        short imageDescriptor;
        this.shouldFlipVertically = shouldFlipVertically;
        this.shouldForceAlpha = shouldForceAlpha;
        if (transparency != null) {
            this.shouldForceAlpha = true;
        }
        BufferedInputStream bis = new BufferedInputStream(imageStream, 100000);
        DataInputStream dis = new DataInputStream(bis);
        int idLength = dis.read();
        dis.skipBytes(11);
        this.imageWidth = this.flipEndian(dis.readShort());
        this.imageHeight = this.flipEndian(dis.readShort());
        this.imageBitDepth = (short)dis.read();
        if (this.imageBitDepth == 32) {
            this.shouldForceAlpha = false;
        }
        this.textureWidth = this.imageWidth;
        this.textureHeight = this.imageHeight;
        if (forceNonePowerOfTwo) {
            this.textureWidth = this.get2Fold(this.imageWidth);
            this.textureHeight = this.get2Fold(this.imageHeight);
        }
        if (((imageDescriptor = (short)dis.read()) & 0x20) == 0) {
            boolean bl = this.shouldFlipVertically = !this.shouldFlipVertically;
        }
        if (idLength > 0) {
            int skipped = 0;
            while (skipped < idLength) {
                skipped = (int)((long)skipped + bis.skip(idLength - skipped));
            }
        }
        if (this.imageBitDepth == 32 || this.shouldForceAlpha) {
            this.imageBitDepth = (short)32;
            rawData = new byte[this.textureWidth * this.textureHeight * 4];
        } else if (this.imageBitDepth == 24) {
            rawData = new byte[this.textureWidth * this.textureHeight * 3];
        } else {
            throw new RuntimeException("Only 24 and 32 bit TGAs are supported");
        }
        if (this.imageBitDepth == 24) {
            if (this.shouldFlipVertically) {
                for (i = this.imageHeight - 1; i >= 0; --i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        ofs = (j + i * this.textureWidth) * 3;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                    }
                }
            } else {
                for (i = 0; i < this.imageHeight; ++i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        ofs = (j + i * this.textureWidth) * 3;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                    }
                }
            }
        } else if (this.imageBitDepth == 32) {
            int alpha;
            if (this.shouldFlipVertically) {
                for (i = this.imageHeight - 1; i >= 0; --i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = this.shouldForceAlpha ? -1 : (int)dis.readByte();
                        ofs = (j + i * this.textureWidth) * 4;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                        rawData[ofs + 3] = alpha;
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            } else {
                for (i = 0; i < this.imageHeight; ++i) {
                    for (j = 0; j < this.imageWidth; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = this.shouldForceAlpha ? -1 : (int)dis.readByte();
                        ofs = (j + i * this.textureWidth) * 4;
                        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                            rawData[ofs] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs + 2] = blue;
                            rawData[ofs + 3] = alpha;
                        } else {
                            rawData[ofs] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs + 2] = blue;
                            rawData[ofs + 3] = alpha;
                        }
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            }
        }
        imageStream.close();
        if (transparency != null) {
            for (i = 0; i < rawData.length; i += 4) {
                boolean match = true;
                for (int c = 0; c < 3; ++c) {
                    if (rawData[i + c] == transparency[c]) continue;
                    match = false;
                }
                if (!match) continue;
                rawData[i + 3] = 0;
            }
        }
        ByteBuffer scratch = this.createNativeOrderedByteBuffer(rawData.length);
        scratch.put(rawData);
        int perPixel = this.imageBitDepth / 8;
        if (this.imageHeight < this.textureHeight - 1) {
            int topOffset = (this.textureHeight - 1) * (this.textureWidth * perPixel);
            int bottomOffset = (this.imageHeight - 1) * (this.textureWidth * perPixel);
            for (int x = 0; x < this.textureWidth * perPixel; ++x) {
                scratch.put(topOffset + x, scratch.get(x));
                scratch.put(bottomOffset + this.textureWidth * perPixel + x, scratch.get(this.textureWidth * perPixel + x));
            }
        }
        if (this.imageWidth < this.textureWidth - 1) {
            for (int y = 0; y < this.textureHeight; ++y) {
                for (int i2 = 0; i2 < perPixel; ++i2) {
                    scratch.put((y + 1) * (this.textureWidth * perPixel) - perPixel + i2, scratch.get(y * (this.textureWidth * perPixel) + i2));
                    scratch.put(y * (this.textureWidth * perPixel) + this.imageWidth * perPixel + i2, scratch.get(y * (this.textureWidth * perPixel) + (this.imageWidth - 1) * perPixel + i2));
                }
            }
        }
        scratch.flip();
        return scratch;
    }

    private short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    @Nonnull
    private ByteBuffer createNativeOrderedByteBuffer(int numBytes) {
        return ByteBuffer.allocateDirect(numBytes).order(ByteOrder.nativeOrder());
    }

    private int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }
}

