/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.io;

import de.lessvoid.nifty.render.io.ImageLoader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.imageio.ImageIO;

public class DefaultImageLoader
implements ImageLoader {
    @Nonnull
    private static final ColorModel GL_ALPHA_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    @Nullable
    private ImageProperties imageProperties;

    @Override
    public int getImageBitDepth() {
        if (this.imageProperties == null) {
            throw new IllegalStateException("Image bit depth is not set!");
        }
        return this.imageProperties.getBitDepth();
    }

    @Override
    public int getImageWidth() {
        if (this.imageProperties == null) {
            throw new IllegalStateException("Image width is not set!");
        }
        return this.imageProperties.getWidth();
    }

    @Override
    public int getImageHeight() {
        if (this.imageProperties == null) {
            throw new IllegalStateException("Image height is not set!");
        }
        return this.imageProperties.getHeight();
    }

    @Override
    public int getTextureWidth() {
        if (this.imageProperties == null) {
            throw new IllegalStateException("Texture width is not set!");
        }
        return this.imageProperties.getWidth();
    }

    @Override
    public int getTextureHeight() {
        if (this.imageProperties == null) {
            throw new IllegalStateException("Texture height is not set!");
        }
        return this.imageProperties.getHeight();
    }

    @Override
    @Nonnull
    public ByteBuffer loadAsByteBufferRGBA(@Nonnull @WillNotClose InputStream imageStream) throws IOException {
        return this.convertToOpenGlFormat(this.loadImageFromStream(imageStream), false, false);
    }

    @Override
    @Nonnull
    public ByteBuffer loadAsByteBufferARGB(@Nonnull @WillNotClose InputStream imageStream, boolean shouldFlipVertically) throws IOException {
        try {
            return this.convertToOpenGlFormat(this.loadImageFromStream(imageStream), shouldFlipVertically, true);
        }
        catch (IOException e) {
            throw new IOException("Could not load mouse cursor image!", e);
        }
    }

    @Override
    @Nonnull
    public BufferedImage loadAsBufferedImage(@Nonnull @WillNotClose InputStream imageStream) throws IOException {
        try {
            return this.loadImageFromStream(imageStream);
        }
        catch (IOException e) {
            throw new IOException("Could not load mouse cursor image!", e);
        }
    }

    private BufferedImage loadImageFromStream(@Nonnull @WillNotClose InputStream imageStream) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IOException("Could not load image from stream as a buffered image!", e);
        }
        if (image == null) {
            throw new IOException("Could not load image from stream as a buffered image!");
        }
        return image;
    }

    @Nonnull
    private ByteBuffer convertToOpenGlFormat(@Nonnull BufferedImage originalImage, boolean shouldFlipVertically, boolean shouldUseARGB) {
        ImageProperties originalImageProperties;
        this.imageProperties = originalImageProperties = new ImageProperties(originalImage.getWidth(), originalImage.getHeight(), shouldFlipVertically);
        BufferedImage openGlImage = this.createImageWithProperties(originalImageProperties);
        Graphics2D openGlImageGraphics = (Graphics2D)openGlImage.getGraphics();
        this.blankImageForMacOsXCompatibility(openGlImageGraphics, originalImageProperties);
        this.copyImage(originalImage, openGlImageGraphics, originalImageProperties);
        byte[] rawOpenGlImageData = this.getRawImageData(openGlImage);
        if (shouldUseARGB) {
            this.convertImageToARGB(rawOpenGlImageData);
        }
        ByteBuffer openGlImageByteBuffer = this.createByteBuffer(rawOpenGlImageData);
        this.disposeImage(openGlImageGraphics);
        return openGlImageByteBuffer;
    }

    private void blankImageForMacOsXCompatibility(@Nonnull Graphics2D imageGraphics, @Nonnull ImageProperties imageProperties) {
        imageGraphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        imageGraphics.fillRect(0, 0, imageProperties.getWidth(), imageProperties.getHeight());
    }

    private void copyImage(@Nonnull BufferedImage sourceImage, @Nonnull Graphics2D destinationGraphics, @Nonnull ImageProperties sourceImageProperties) {
        if (sourceImageProperties.isFlipped()) {
            destinationGraphics.scale(1.0, -1.0);
            destinationGraphics.drawImage((Image)sourceImage, 0, -sourceImageProperties.getHeight(), null);
        } else {
            destinationGraphics.drawImage((Image)sourceImage, 0, 0, null);
        }
    }

    @Nonnull
    private BufferedImage createImageWithProperties(@Nonnull ImageProperties imageProperties) {
        return new BufferedImage(imageProperties.getColorModel(), this.createRasterWithProperties(imageProperties), false, null);
    }

    @Nonnull
    private WritableRaster createRasterWithProperties(@Nonnull ImageProperties imageProperties) {
        return Raster.createInterleavedRaster(0, imageProperties.getWidth(), imageProperties.getHeight(), imageProperties.getColorBands(), null);
    }

    @Nonnull
    private ByteBuffer createByteBuffer(@Nonnull byte[] data) {
        return ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder()).put(data, 0, data.length).flip();
    }

    private void convertImageToARGB(@Nonnull byte[] imageData) {
        for (int i = 0; i < imageData.length; i += 4) {
            byte rr = imageData[i];
            byte gg = imageData[i + 1];
            byte bb = imageData[i + 2];
            byte aa = imageData[i + 3];
            imageData[i] = bb;
            imageData[i + 1] = gg;
            imageData[i + 2] = rr;
            imageData[i + 3] = aa;
        }
    }

    @Nonnull
    private byte[] getRawImageData(@Nonnull BufferedImage image) {
        return ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
    }

    private void disposeImage(@Nonnull Graphics2D graphics2D) {
        graphics2D.dispose();
    }

    private static class ImageProperties {
        private final int width;
        private final int height;
        private final boolean isFlippedVertically;

        private ImageProperties(int width, int height, boolean isFlippedVertically) {
            this.width = width;
            this.height = height;
            this.isFlippedVertically = isFlippedVertically;
        }

        private int getWidth() {
            return this.width;
        }

        private int getHeight() {
            return this.height;
        }

        private boolean isFlipped() {
            return this.isFlippedVertically;
        }

        private ColorModel getColorModel() {
            return GL_ALPHA_COLOR_MODEL;
        }

        private int getBitDepth() {
            return 32;
        }

        private int getColorBands() {
            return 4;
        }
    }
}

