/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.spi.core;

import de.lessvoid.nifty.render.batch.spi.core.CoreVector4f;
import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CoreMatrix4f {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public CoreMatrix4f() {
        this.setIdentity();
    }

    public CoreMatrix4f(@Nonnull CoreMatrix4f src) {
        this.load(src);
    }

    @Nonnull
    public String toString() {
        return String.valueOf(this.m00) + ' ' + this.m10 + ' ' + this.m20 + ' ' + this.m30 + '\n' + this.m01 + ' ' + this.m11 + ' ' + this.m21 + ' ' + this.m31 + '\n' + this.m02 + ' ' + this.m12 + ' ' + this.m22 + ' ' + this.m32 + '\n' + this.m03 + ' ' + this.m13 + ' ' + this.m23 + ' ' + this.m33 + '\n';
    }

    @Nonnull
    public CoreMatrix4f setIdentity() {
        return CoreMatrix4f.setIdentity(this);
    }

    @Nonnull
    public static CoreMatrix4f setIdentity(@Nonnull CoreMatrix4f m) {
        m.m00 = 1.0f;
        m.m01 = 0.0f;
        m.m02 = 0.0f;
        m.m03 = 0.0f;
        m.m10 = 0.0f;
        m.m11 = 1.0f;
        m.m12 = 0.0f;
        m.m13 = 0.0f;
        m.m20 = 0.0f;
        m.m21 = 0.0f;
        m.m22 = 1.0f;
        m.m23 = 0.0f;
        m.m30 = 0.0f;
        m.m31 = 0.0f;
        m.m32 = 0.0f;
        m.m33 = 1.0f;
        return m;
    }

    @Nonnull
    public CoreMatrix4f setZero() {
        return CoreMatrix4f.setZero(this);
    }

    @Nonnull
    public static CoreMatrix4f setZero(@Nonnull CoreMatrix4f m) {
        m.m00 = 0.0f;
        m.m01 = 0.0f;
        m.m02 = 0.0f;
        m.m03 = 0.0f;
        m.m10 = 0.0f;
        m.m11 = 0.0f;
        m.m12 = 0.0f;
        m.m13 = 0.0f;
        m.m20 = 0.0f;
        m.m21 = 0.0f;
        m.m22 = 0.0f;
        m.m23 = 0.0f;
        m.m30 = 0.0f;
        m.m31 = 0.0f;
        m.m32 = 0.0f;
        m.m33 = 0.0f;
        return m;
    }

    @Nonnull
    public static CoreMatrix4f createTranslation(float x, float y, float z) {
        CoreMatrix4f result = new CoreMatrix4f();
        result.m30 = x;
        result.m31 = y;
        result.m32 = z;
        return result;
    }

    @Nonnull
    public static CoreMatrix4f createScaling(float x, float y, float z) {
        CoreMatrix4f result = new CoreMatrix4f();
        result.m00 = x;
        result.m11 = y;
        result.m22 = z;
        return result;
    }

    @Nonnull
    public static CoreMatrix4f createRotation(float angle, float x, float y, float z) {
        double angleRad = (double)angle * Math.PI / 180.0;
        float c = (float)Math.cos(angleRad);
        float s = (float)Math.sin(angleRad);
        CoreMatrix4f result = new CoreMatrix4f();
        result.m00 = x * x * (1.0f - c) + c;
        result.m10 = x * y * (1.0f - c) - z * s;
        result.m20 = x * z * (1.0f - c) + y * s;
        result.m30 = 0.0f;
        result.m01 = y * x * (1.0f - c) + z * s;
        result.m11 = y * y * (1.0f - c) + c;
        result.m21 = y * z * (1.0f - c) - x * s;
        result.m31 = 0.0f;
        result.m02 = x * z * (1.0f - c) - y * s;
        result.m12 = y * z * (1.0f - c) + x * s;
        result.m22 = z * z * (1.0f - c) + c;
        result.m32 = 0.0f;
        result.m03 = 0.0f;
        result.m13 = 0.0f;
        result.m23 = 0.0f;
        result.m33 = 1.0f;
        return result;
    }

    @Nonnull
    public CoreMatrix4f load(@Nonnull CoreMatrix4f src) {
        return CoreMatrix4f.load(src, this);
    }

    @Nonnull
    public static CoreMatrix4f load(@Nonnull CoreMatrix4f src, @Nullable CoreMatrix4f dest) {
        if (dest == null) {
            dest = new CoreMatrix4f();
        }
        dest.m00 = src.m00;
        dest.m01 = src.m01;
        dest.m02 = src.m02;
        dest.m03 = src.m03;
        dest.m10 = src.m10;
        dest.m11 = src.m11;
        dest.m12 = src.m12;
        dest.m13 = src.m13;
        dest.m20 = src.m20;
        dest.m21 = src.m21;
        dest.m22 = src.m22;
        dest.m23 = src.m23;
        dest.m30 = src.m30;
        dest.m31 = src.m31;
        dest.m32 = src.m32;
        dest.m33 = src.m33;
        return dest;
    }

    @Nonnull
    public CoreMatrix4f load(@Nonnull FloatBuffer buffer) {
        this.m00 = buffer.get();
        this.m01 = buffer.get();
        this.m02 = buffer.get();
        this.m03 = buffer.get();
        this.m10 = buffer.get();
        this.m11 = buffer.get();
        this.m12 = buffer.get();
        this.m13 = buffer.get();
        this.m20 = buffer.get();
        this.m21 = buffer.get();
        this.m22 = buffer.get();
        this.m23 = buffer.get();
        this.m30 = buffer.get();
        this.m31 = buffer.get();
        this.m32 = buffer.get();
        this.m33 = buffer.get();
        return this;
    }

    @Nonnull
    public CoreMatrix4f loadTransposed(@Nonnull FloatBuffer buffer) {
        this.m00 = buffer.get();
        this.m10 = buffer.get();
        this.m20 = buffer.get();
        this.m30 = buffer.get();
        this.m01 = buffer.get();
        this.m11 = buffer.get();
        this.m21 = buffer.get();
        this.m31 = buffer.get();
        this.m02 = buffer.get();
        this.m12 = buffer.get();
        this.m22 = buffer.get();
        this.m32 = buffer.get();
        this.m03 = buffer.get();
        this.m13 = buffer.get();
        this.m23 = buffer.get();
        this.m33 = buffer.get();
        return this;
    }

    @Nonnull
    public CoreMatrix4f store(@Nonnull FloatBuffer buffer) {
        buffer.put(this.m00);
        buffer.put(this.m01);
        buffer.put(this.m02);
        buffer.put(this.m03);
        buffer.put(this.m10);
        buffer.put(this.m11);
        buffer.put(this.m12);
        buffer.put(this.m13);
        buffer.put(this.m20);
        buffer.put(this.m21);
        buffer.put(this.m22);
        buffer.put(this.m23);
        buffer.put(this.m30);
        buffer.put(this.m31);
        buffer.put(this.m32);
        buffer.put(this.m33);
        return this;
    }

    @Nonnull
    public CoreMatrix4f storeTransposed(@Nonnull FloatBuffer buffer) {
        buffer.put(this.m00);
        buffer.put(this.m10);
        buffer.put(this.m20);
        buffer.put(this.m30);
        buffer.put(this.m01);
        buffer.put(this.m11);
        buffer.put(this.m21);
        buffer.put(this.m31);
        buffer.put(this.m02);
        buffer.put(this.m12);
        buffer.put(this.m22);
        buffer.put(this.m32);
        buffer.put(this.m03);
        buffer.put(this.m13);
        buffer.put(this.m23);
        buffer.put(this.m33);
        return this;
    }

    @Nonnull
    public CoreMatrix4f store3f(@Nonnull FloatBuffer buffer) {
        buffer.put(this.m00);
        buffer.put(this.m01);
        buffer.put(this.m02);
        buffer.put(this.m10);
        buffer.put(this.m11);
        buffer.put(this.m12);
        buffer.put(this.m20);
        buffer.put(this.m21);
        buffer.put(this.m22);
        return this;
    }

    @Nonnull
    public static CoreMatrix4f add(@Nonnull CoreMatrix4f left, @Nonnull CoreMatrix4f right, @Nullable CoreMatrix4f result) {
        if (result == null) {
            result = new CoreMatrix4f();
        }
        result.m00 = left.m00 + right.m00;
        result.m01 = left.m01 + right.m01;
        result.m02 = left.m02 + right.m02;
        result.m03 = left.m03 + right.m03;
        result.m10 = left.m10 + right.m10;
        result.m11 = left.m11 + right.m11;
        result.m12 = left.m12 + right.m12;
        result.m13 = left.m13 + right.m13;
        result.m20 = left.m20 + right.m20;
        result.m21 = left.m21 + right.m21;
        result.m22 = left.m22 + right.m22;
        result.m23 = left.m23 + right.m23;
        result.m30 = left.m30 + right.m30;
        result.m31 = left.m31 + right.m31;
        result.m32 = left.m32 + right.m32;
        result.m33 = left.m33 + right.m33;
        return result;
    }

    @Nonnull
    public static CoreMatrix4f subtract(@Nonnull CoreMatrix4f left, @Nonnull CoreMatrix4f right, @Nullable CoreMatrix4f result) {
        if (result == null) {
            result = new CoreMatrix4f();
        }
        result.m00 = left.m00 - right.m00;
        result.m01 = left.m01 - right.m01;
        result.m02 = left.m02 - right.m02;
        result.m03 = left.m03 - right.m03;
        result.m10 = left.m10 - right.m10;
        result.m11 = left.m11 - right.m11;
        result.m12 = left.m12 - right.m12;
        result.m13 = left.m13 - right.m13;
        result.m20 = left.m20 - right.m20;
        result.m21 = left.m21 - right.m21;
        result.m22 = left.m22 - right.m22;
        result.m23 = left.m23 - right.m23;
        result.m30 = left.m30 - right.m30;
        result.m31 = left.m31 - right.m31;
        result.m32 = left.m32 - right.m32;
        result.m33 = left.m33 - right.m33;
        return result;
    }

    @Nonnull
    public static CoreMatrix4f multiply(@Nonnull CoreMatrix4f left, @Nonnull CoreMatrix4f right) {
        return CoreMatrix4f.multiply(left, right, null);
    }

    @Nonnull
    public static CoreMatrix4f multiply(@Nonnull CoreMatrix4f left, @Nonnull CoreMatrix4f right, @Nullable CoreMatrix4f result) {
        if (result == null) {
            result = new CoreMatrix4f();
        }
        float m00 = left.m00 * right.m00 + left.m10 * right.m01 + left.m20 * right.m02 + left.m30 * right.m03;
        float m01 = left.m01 * right.m00 + left.m11 * right.m01 + left.m21 * right.m02 + left.m31 * right.m03;
        float m02 = left.m02 * right.m00 + left.m12 * right.m01 + left.m22 * right.m02 + left.m32 * right.m03;
        float m03 = left.m03 * right.m00 + left.m13 * right.m01 + left.m23 * right.m02 + left.m33 * right.m03;
        float m10 = left.m00 * right.m10 + left.m10 * right.m11 + left.m20 * right.m12 + left.m30 * right.m13;
        float m11 = left.m01 * right.m10 + left.m11 * right.m11 + left.m21 * right.m12 + left.m31 * right.m13;
        float m12 = left.m02 * right.m10 + left.m12 * right.m11 + left.m22 * right.m12 + left.m32 * right.m13;
        float m13 = left.m03 * right.m10 + left.m13 * right.m11 + left.m23 * right.m12 + left.m33 * right.m13;
        float m20 = left.m00 * right.m20 + left.m10 * right.m21 + left.m20 * right.m22 + left.m30 * right.m23;
        float m21 = left.m01 * right.m20 + left.m11 * right.m21 + left.m21 * right.m22 + left.m31 * right.m23;
        float m22 = left.m02 * right.m20 + left.m12 * right.m21 + left.m22 * right.m22 + left.m32 * right.m23;
        float m23 = left.m03 * right.m20 + left.m13 * right.m21 + left.m23 * right.m22 + left.m33 * right.m23;
        float m30 = left.m00 * right.m30 + left.m10 * right.m31 + left.m20 * right.m32 + left.m30 * right.m33;
        float m31 = left.m01 * right.m30 + left.m11 * right.m31 + left.m21 * right.m32 + left.m31 * right.m33;
        float m32 = left.m02 * right.m30 + left.m12 * right.m31 + left.m22 * right.m32 + left.m32 * right.m33;
        float m33 = left.m03 * right.m30 + left.m13 * right.m31 + left.m23 * right.m32 + left.m33 * right.m33;
        result.m00 = m00;
        result.m01 = m01;
        result.m02 = m02;
        result.m03 = m03;
        result.m10 = m10;
        result.m11 = m11;
        result.m12 = m12;
        result.m13 = m13;
        result.m20 = m20;
        result.m21 = m21;
        result.m22 = m22;
        result.m23 = m23;
        result.m30 = m30;
        result.m31 = m31;
        result.m32 = m32;
        result.m33 = m33;
        return result;
    }

    @Nonnull
    public CoreMatrix4f transpose() {
        return this.transpose(this);
    }

    @Nonnull
    public CoreMatrix4f transpose(@Nullable CoreMatrix4f result) {
        return CoreMatrix4f.transpose(this, result);
    }

    @Nonnull
    public static CoreMatrix4f transpose(@Nonnull CoreMatrix4f src, @Nullable CoreMatrix4f result) {
        if (result == null) {
            result = new CoreMatrix4f();
        }
        float m00 = src.m00;
        float m01 = src.m10;
        float m02 = src.m20;
        float m03 = src.m30;
        float m10 = src.m01;
        float m11 = src.m11;
        float m12 = src.m21;
        float m13 = src.m31;
        float m20 = src.m02;
        float m21 = src.m12;
        float m22 = src.m22;
        float m23 = src.m32;
        float m30 = src.m03;
        float m31 = src.m13;
        float m32 = src.m23;
        float m33 = src.m33;
        result.m00 = m00;
        result.m01 = m01;
        result.m02 = m02;
        result.m03 = m03;
        result.m10 = m10;
        result.m11 = m11;
        result.m12 = m12;
        result.m13 = m13;
        result.m20 = m20;
        result.m21 = m21;
        result.m22 = m22;
        result.m23 = m23;
        result.m30 = m30;
        result.m31 = m31;
        result.m32 = m32;
        result.m33 = m33;
        return result;
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    @Nullable
    public CoreMatrix4f invert() {
        return CoreMatrix4f.invert(this, this);
    }

    @Nullable
    public static CoreMatrix4f invert(@Nonnull CoreMatrix4f src, @Nullable CoreMatrix4f result) {
        float determinant = src.determinant();
        if (determinant != 0.0f) {
            if (result == null) {
                result = new CoreMatrix4f();
            }
            float determinant_inv = 1.0f / determinant;
            float t00 = CoreMatrix4f.determinant3x3(src.m11, src.m12, src.m13, src.m21, src.m22, src.m23, src.m31, src.m32, src.m33);
            float t01 = -CoreMatrix4f.determinant3x3(src.m10, src.m12, src.m13, src.m20, src.m22, src.m23, src.m30, src.m32, src.m33);
            float t02 = CoreMatrix4f.determinant3x3(src.m10, src.m11, src.m13, src.m20, src.m21, src.m23, src.m30, src.m31, src.m33);
            float t03 = -CoreMatrix4f.determinant3x3(src.m10, src.m11, src.m12, src.m20, src.m21, src.m22, src.m30, src.m31, src.m32);
            float t10 = -CoreMatrix4f.determinant3x3(src.m01, src.m02, src.m03, src.m21, src.m22, src.m23, src.m31, src.m32, src.m33);
            float t11 = CoreMatrix4f.determinant3x3(src.m00, src.m02, src.m03, src.m20, src.m22, src.m23, src.m30, src.m32, src.m33);
            float t12 = -CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m03, src.m20, src.m21, src.m23, src.m30, src.m31, src.m33);
            float t13 = CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m02, src.m20, src.m21, src.m22, src.m30, src.m31, src.m32);
            float t20 = CoreMatrix4f.determinant3x3(src.m01, src.m02, src.m03, src.m11, src.m12, src.m13, src.m31, src.m32, src.m33);
            float t21 = -CoreMatrix4f.determinant3x3(src.m00, src.m02, src.m03, src.m10, src.m12, src.m13, src.m30, src.m32, src.m33);
            float t22 = CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m03, src.m10, src.m11, src.m13, src.m30, src.m31, src.m33);
            float t23 = -CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m02, src.m10, src.m11, src.m12, src.m30, src.m31, src.m32);
            float t30 = -CoreMatrix4f.determinant3x3(src.m01, src.m02, src.m03, src.m11, src.m12, src.m13, src.m21, src.m22, src.m23);
            float t31 = CoreMatrix4f.determinant3x3(src.m00, src.m02, src.m03, src.m10, src.m12, src.m13, src.m20, src.m22, src.m23);
            float t32 = -CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m03, src.m10, src.m11, src.m13, src.m20, src.m21, src.m23);
            float t33 = CoreMatrix4f.determinant3x3(src.m00, src.m01, src.m02, src.m10, src.m11, src.m12, src.m20, src.m21, src.m22);
            result.m00 = t00 * determinant_inv;
            result.m11 = t11 * determinant_inv;
            result.m22 = t22 * determinant_inv;
            result.m33 = t33 * determinant_inv;
            result.m01 = t10 * determinant_inv;
            result.m10 = t01 * determinant_inv;
            result.m20 = t02 * determinant_inv;
            result.m02 = t20 * determinant_inv;
            result.m12 = t21 * determinant_inv;
            result.m21 = t12 * determinant_inv;
            result.m03 = t30 * determinant_inv;
            result.m30 = t03 * determinant_inv;
            result.m13 = t31 * determinant_inv;
            result.m31 = t13 * determinant_inv;
            result.m32 = t23 * determinant_inv;
            result.m23 = t32 * determinant_inv;
            return result;
        }
        return null;
    }

    @Nonnull
    public CoreMatrix4f negate() {
        return this.negate(this);
    }

    @Nonnull
    public CoreMatrix4f negate(@Nullable CoreMatrix4f result) {
        return CoreMatrix4f.negate(this, this);
    }

    @Nonnull
    public static CoreMatrix4f negate(@Nonnull CoreMatrix4f src, @Nullable CoreMatrix4f result) {
        if (result == null) {
            result = new CoreMatrix4f();
        }
        result.m00 = -src.m00;
        result.m01 = -src.m01;
        result.m02 = -src.m02;
        result.m03 = -src.m03;
        result.m10 = -src.m10;
        result.m11 = -src.m11;
        result.m12 = -src.m12;
        result.m13 = -src.m13;
        result.m20 = -src.m20;
        result.m21 = -src.m21;
        result.m22 = -src.m22;
        result.m23 = -src.m23;
        result.m30 = -src.m30;
        result.m31 = -src.m31;
        result.m32 = -src.m32;
        result.m33 = -src.m33;
        return result;
    }

    @Nonnull
    public static CoreMatrix4f createIdentity() {
        return new CoreMatrix4f();
    }

    @Nonnull
    public static CoreVector4f transform(@Nonnull CoreMatrix4f left, @Nonnull CoreVector4f right) {
        return CoreMatrix4f.transform(left, right, null);
    }

    @Nonnull
    public static CoreVector4f transform(@Nonnull CoreMatrix4f left, @Nonnull CoreVector4f right, @Nullable CoreVector4f result) {
        if (result == null) {
            result = new CoreVector4f();
        }
        float x = left.m00 * right.x + left.m10 * right.y + left.m20 * right.z + left.m30 * right.w;
        float y = left.m01 * right.x + left.m11 * right.y + left.m21 * right.z + left.m31 * right.w;
        float z = left.m02 * right.x + left.m12 * right.y + left.m22 * right.z + left.m32 * right.w;
        float w = left.m03 * right.x + left.m13 * right.y + left.m23 * right.z + left.m33 * right.w;
        result.x = x;
        result.y = y;
        result.z = z;
        result.w = w;
        return result;
    }

    public boolean compare(@Nonnull CoreMatrix4f other) {
        return this.equals(this.m00, other.m00) && this.equals(this.m01, other.m01) && this.equals(this.m02, other.m02) && this.equals(this.m03, other.m03) && this.equals(this.m10, other.m10) && this.equals(this.m11, other.m11) && this.equals(this.m12, other.m12) && this.equals(this.m13, other.m13) && this.equals(this.m20, other.m20) && this.equals(this.m21, other.m21) && this.equals(this.m22, other.m22) && this.equals(this.m23, other.m23) && this.equals(this.m30, other.m30) && this.equals(this.m31, other.m31) && this.equals(this.m32, other.m32) && this.equals(this.m33, other.m33);
    }

    private static float determinant3x3(float t00, float t01, float t02, float t10, float t11, float t12, float t20, float t21, float t22) {
        return t00 * (t11 * t22 - t12 * t21) + t01 * (t12 * t20 - t10 * t22) + t02 * (t10 * t21 - t11 * t20);
    }

    private boolean equals(float a, float b) {
        return Math.abs(a - b) < 1.0E-8f;
    }
}

