/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;

public class CoreVBO {
    @Nonnull
    private final CoreGL gl;
    private final int id;
    private final int usage;
    private final long byteLength;
    @Nonnull
    private final FloatBuffer vertexBuffer;
    @Nonnull
    private final IntBuffer idBuffer;
    private ByteBuffer mappedBufferCache;

    @Nonnull
    public static CoreVBO createStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull float[] data) {
        return new CoreVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data);
    }

    @Nonnull
    public static CoreVBO createAndSendStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull float[] data) {
        CoreVBO result = new CoreVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data);
        result.send();
        return result;
    }

    @Nonnull
    public static CoreVBO createAndSendStaticVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull FloatBuffer data) {
        CoreVBO result = new CoreVBO(gl, bufferFactory, gl.GL_STATIC_DRAW(), data.array());
        result.send();
        return result;
    }

    @Nonnull
    public static CoreVBO createDynamicVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull float[] data) {
        return new CoreVBO(gl, bufferFactory, gl.GL_DYNAMIC_DRAW(), data);
    }

    @Nonnull
    public static CoreVBO createStreamVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, @Nonnull float[] data) {
        return new CoreVBO(gl, bufferFactory, gl.GL_STREAM_DRAW(), data);
    }

    private CoreVBO(@Nonnull CoreGL gl, @Nonnull BufferFactory bufferFactory, int usageType, @Nonnull float[] data) {
        this.gl = gl;
        this.usage = usageType;
        this.byteLength = data.length << 2;
        this.vertexBuffer = bufferFactory.createNativeOrderedFloatBuffer(data.length);
        this.vertexBuffer.put(data);
        this.vertexBuffer.rewind();
        this.idBuffer = bufferFactory.createNativeOrderedIntBuffer(1);
        gl.glGenBuffers(1, this.idBuffer);
        this.id = this.idBuffer.get(0);
        CheckGL.checkGLError(gl, "glGenBuffers");
        gl.glBindBuffer(gl.GL_ARRAY_BUFFER(), this.id);
        gl.glBufferData(gl.GL_ARRAY_BUFFER(), this.vertexBuffer, this.usage);
        CheckGL.checkGLError(gl, "glBufferData");
    }

    public FloatBuffer getBuffer() {
        return this.vertexBuffer;
    }

    @Nonnull
    public FloatBuffer getMappedBuffer() {
        ByteBuffer dataBuffer = this.gl.glMapBuffer(this.gl.GL_ARRAY_BUFFER(), this.gl.GL_WRITE_ONLY(), this.byteLength, this.mappedBufferCache);
        CheckGL.checkGLError(this.gl, "getMappedBuffer(GL_ARRAY_BUFFER)");
        this.mappedBufferCache = dataBuffer;
        return dataBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public void unmapBuffer() {
        this.gl.glUnmapBuffer(this.gl.GL_ARRAY_BUFFER());
    }

    public void bind() {
        this.gl.glBindBuffer(this.gl.GL_ARRAY_BUFFER(), this.id);
        CheckGL.checkGLError(this.gl, "glBindBuffer(GL_ARRAY_BUFFER)");
    }

    public void send() {
        this.gl.glBufferData(this.gl.GL_ARRAY_BUFFER(), this.vertexBuffer, this.usage);
        CheckGL.checkGLError(this.gl, "glBufferData(GL_ARRAY_BUFFER)");
    }

    public void delete() {
        this.idBuffer.clear();
        this.idBuffer.put(0, this.id);
        this.gl.glDeleteBuffers(1, this.idBuffer);
    }
}

