/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch.core;

import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.BatchRenderBackendInternal;
import de.lessvoid.nifty.render.batch.CheckGL;
import de.lessvoid.nifty.render.batch.core.CoreBatchInternal;
import de.lessvoid.nifty.render.batch.core.CoreProfileSaveGLState;
import de.lessvoid.nifty.render.batch.core.CoreShader;
import de.lessvoid.nifty.render.batch.core.CoreTexture2D;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.render.batch.spi.BufferFactory;
import de.lessvoid.nifty.render.batch.spi.ImageFactory;
import de.lessvoid.nifty.render.batch.spi.MouseCursorFactory;
import de.lessvoid.nifty.render.batch.spi.core.CoreBatch;
import de.lessvoid.nifty.render.batch.spi.core.CoreGL;
import de.lessvoid.nifty.render.batch.spi.core.CoreMatrixFactory;
import de.lessvoid.nifty.render.io.ImageLoader;
import de.lessvoid.nifty.render.io.ImageLoaderFactory;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.Factory;
import de.lessvoid.nifty.tools.ObjectPool;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchRenderBackendCoreProfileInternal
implements BatchRenderBackend {
    @Nonnull
    private static final Logger log = Logger.getLogger(BatchRenderBackendInternal.class.getName());
    private static final int PRIMITIVE_RESTART_INDEX = 65535;
    private static final int INVALID_TEXTURE_ID = -1;
    @Nonnull
    private final CoreGL gl;
    @Nonnull
    private final BufferFactory bufferFactory;
    @Nonnull
    private final ImageFactory imageFactory;
    @Nonnull
    private final MouseCursorFactory mouseCursorFactory;
    @Nonnull
    private final CoreShader shader;
    @Nonnull
    private final IntBuffer viewportBuffer;
    @Nonnull
    private final ObjectPool<CoreBatch> batchPool;
    @Nonnull
    private final CoreProfileSaveGLState saveGLState;
    @Nonnull
    private final List<CoreBatch> batches = new ArrayList<CoreBatch>();
    @Nonnull
    private final Map<Integer, CoreTexture2D> atlasTextures = new HashMap<Integer, CoreTexture2D>();
    @Nonnull
    private final Map<Integer, CoreTexture2D> nonAtlasTextures = new HashMap<Integer, CoreTexture2D>();
    @Nonnull
    private final Map<String, MouseCursor> cursorCache = new HashMap<String, MouseCursor>();
    @Nullable
    private MouseCursor mouseCursor;
    @Nullable
    private NiftyResourceLoader resourceLoader;
    @Nullable
    private CoreBatch currentBatch;
    private int viewportWidth;
    private int viewportHeight;
    private boolean shouldUseHighQualityTextures = false;
    private boolean shouldFillRemovedImagesInAtlas = false;

    public BatchRenderBackendCoreProfileInternal(final @Nonnull CoreGL gl, final @Nonnull BufferFactory bufferFactory, @Nonnull ImageFactory imageFactory, @Nonnull MouseCursorFactory mouseCursorFactory) {
        this.gl = gl;
        this.bufferFactory = bufferFactory;
        this.imageFactory = imageFactory;
        this.mouseCursorFactory = mouseCursorFactory;
        this.saveGLState = new CoreProfileSaveGLState(gl, bufferFactory);
        this.viewportBuffer = bufferFactory.createNativeOrderedIntBuffer(16);
        this.shader = CoreShader.createShaderWithVertexAttributes(gl, bufferFactory, "aVertex", "aColor", "aTexture");
        this.shader.fragmentShader("nifty.fs");
        this.shader.vertexShader("nifty.vs");
        this.shader.link();
        this.shader.activate();
        this.shader.setUniformi("uTex", 0);
        this.batchPool = new ObjectPool<CoreBatch>(new Factory<CoreBatch>(){

            @Override
            @Nonnull
            public CoreBatch createNew() {
                return new CoreBatchInternal(gl, BatchRenderBackendCoreProfileInternal.this.shader, bufferFactory, 65535);
            }
        });
    }

    @Override
    public void setResourceLoader(@Nonnull NiftyResourceLoader resourceLoader) {
        log.fine("setResourceLoader()");
        this.resourceLoader = resourceLoader;
    }

    @Override
    public int getWidth() {
        log.fine("getWidth()");
        this.updateViewport();
        return this.viewportWidth;
    }

    @Override
    public int getHeight() {
        log.fine("getHeight()");
        this.updateViewport();
        return this.viewportHeight;
    }

    @Override
    public void beginFrame() {
        log.fine("beginFrame()");
        this.saveGLState.saveCore();
        this.shader.activate();
        this.shader.setUniformMatrix4f("uModelViewProjectionMatrix", CoreMatrixFactory.createOrthoMatrix(0.0f, this.getWidth(), this.getHeight(), 0.0f));
        this.deleteBatches();
    }

    @Override
    public void endFrame() {
        log.fine("endFrame()");
        this.saveGLState.restoreCore();
        CheckGL.checkGLError(this.gl);
    }

    @Override
    public void clear() {
        log.fine("clear()");
        this.clearGlColorBufferWithBlack();
    }

    @Override
    @Nullable
    public MouseCursor createMouseCursor(@Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        log.fine("createMouseCursor()");
        return this.existsCursor(filename) ? this.getCursor(filename) : this.createCursor(filename, hotspotX, hotspotY);
    }

    @Override
    public void enableMouseCursor(@Nonnull MouseCursor mouseCursor) {
        log.fine("enableMouseCursor()");
        this.mouseCursor = mouseCursor;
        mouseCursor.enable();
    }

    @Override
    public void disableMouseCursor() {
        if (this.mouseCursor != null) {
            log.fine("disableMouseCursor()");
            this.mouseCursor.disable();
        }
    }

    @Override
    public int createTextureAtlas(int atlasWidth, int atlasHeight) {
        log.fine("createTextureAtlas()");
        try {
            return this.createAtlasTextureInternal(atlasWidth, atlasHeight);
        }
        catch (Exception e) {
            this.textureCreationFailed(atlasWidth, atlasHeight, e);
            return -1;
        }
    }

    @Override
    public void clearTextureAtlas(int atlasTextureId) {
        log.fine("clearTextureAtlas()");
        this.updateAtlasTexture(atlasTextureId, this.createBlankImageDataForAtlas(atlasTextureId));
    }

    @Override
    @Nonnull
    public BatchRenderBackend.Image loadImage(@Nonnull String filename) {
        log.fine("loadImage()");
        return this.createImageFromFile(filename);
    }

    @Override
    @Nullable
    public BatchRenderBackend.Image loadImage(@Nonnull ByteBuffer imageData, int imageWidth, int imageHeight) {
        log.fine("loadImage2()");
        return this.imageFactory.create(imageData, imageWidth, imageHeight);
    }

    @Override
    public void addImageToAtlas(@Nonnull BatchRenderBackend.Image image, int atlasX, int atlasY, int atlasTextureId) {
        log.fine("addImageToAtlas()");
        log.fine("addImageToAtlas with atlas texture id: " + atlasTextureId);
        this.updateAtlasTextureSection(atlasTextureId, this.imageFactory.asByteBuffer(image), atlasX, atlasY, image.getWidth(), image.getHeight());
    }

    @Override
    public int createNonAtlasTexture(@Nonnull BatchRenderBackend.Image image) {
        log.fine("createNonAtlasTexture()");
        try {
            if (this.imageFactory.asByteBuffer(image) == null) {
                log.severe("Attempted to create a non atlas texture with null image data!");
                return -1;
            }
            return this.createNonAtlasTextureInternal(this.imageFactory.asByteBuffer(image), image.getWidth(), image.getHeight());
        }
        catch (Exception e) {
            this.textureCreationFailed(image.getWidth(), image.getHeight(), e);
            return -1;
        }
    }

    @Override
    public void deleteNonAtlasTexture(int textureId) {
        log.fine("deleteNonAtlasTexture()");
        try {
            this.deleteNonAtlasTextureInternal(textureId);
        }
        catch (Exception e) {
            this.textureDeletionFailed(textureId, e);
        }
    }

    @Override
    public boolean existsNonAtlasTexture(int textureId) {
        log.fine("existsNonAtlasTexture()");
        return this.nonAtlasTextures.containsKey(textureId);
    }

    @Override
    public void addQuad(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight, int textureId) {
        log.fine("addQuad()");
        this.updateCurrentBatch(textureId);
        this.addQuadToCurrentBatch(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
    }

    @Override
    public void beginBatch(@Nonnull BlendMode blendMode, int textureId) {
        log.fine("beginBatch()");
        this.currentBatch = this.createNewBatch();
        this.addBatch(this.currentBatch);
        this.currentBatch.begin(blendMode, this.findTexture(textureId));
    }

    @Override
    public int render() {
        log.fine("render()");
        this.beginRendering();
        this.renderBatches();
        this.endRendering();
        return this.getTotalBatchesRendered();
    }

    @Override
    public void removeImageFromAtlas(@Nonnull BatchRenderBackend.Image image, int atlasX, int atlasY, int imageWidth, int imageHeight, int atlasTextureId) {
        if (!this.shouldFillRemovedImagesInAtlas) {
            return;
        }
        log.fine("removeImageFromAtlas()");
        this.updateAtlasTextureSection(atlasTextureId, this.createBlankImageData(imageWidth, imageHeight), atlasX, atlasY, imageWidth, imageHeight);
    }

    @Override
    public void useHighQualityTextures(boolean shouldUseHighQualityTextures) {
        log.fine("useHighQualityTextures()");
        log.info(shouldUseHighQualityTextures ? "Using high quality textures (near & far trilinear filtering with mipmaps)." : "Using low quality textures (no filtering).");
        this.shouldUseHighQualityTextures = shouldUseHighQualityTextures;
    }

    @Override
    public void fillRemovedImagesInAtlas(boolean shouldFill) {
        log.fine("fillRemovedImagesInAtlas()");
        log.info(shouldFill ? "Filling in removed images in atlas." : "Not filling in removed images in atlas.");
        this.shouldFillRemovedImagesInAtlas = shouldFill;
    }

    private void updateViewport() {
        this.viewportBuffer.clear();
        this.gl.glGetIntegerv(this.gl.GL_VIEWPORT(), this.viewportBuffer);
        this.viewportWidth = this.viewportBuffer.get(2);
        this.viewportHeight = this.viewportBuffer.get(3);
        log.fine("Updated viewport: width: " + this.viewportWidth + ", height: " + this.viewportHeight);
    }

    @Nonnull
    private ByteBuffer createBlankImageDataForAtlas(int atlasTextureId) {
        return this.createBlankImageData(this.getAtlasWidth(atlasTextureId), this.getAtlasHeight(atlasTextureId));
    }

    @Nonnull
    private ByteBuffer createBlankImageData(int textureWidth, int textureHeight) {
        return this.bufferFactory.createNativeOrderedByteBuffer(textureWidth * textureHeight * 4);
    }

    private int getAtlasWidth(int atlasTextureId) {
        return this.getAtlasTexture(atlasTextureId).getWidth();
    }

    private int getAtlasHeight(int atlasTextureId) {
        return this.getAtlasTexture(atlasTextureId).getHeight();
    }

    private void deleteBatches() {
        for (CoreBatch batch : this.batches) {
            this.batchPool.free(batch);
        }
        this.batches.clear();
    }

    private void clearGlColorBufferWithBlack() {
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(this.gl.GL_COLOR_BUFFER_BIT());
    }

    private int createAtlasTextureInternal(int width, int height) throws Exception {
        CoreTexture2D atlasTexture = this.createTexture(this.createBlankImageData(width, height), width, height);
        log.fine("createAtlasTextureInternal with atlas texture id: " + atlasTexture.getId());
        this.atlasTextures.put(atlasTexture.getId(), atlasTexture);
        return atlasTexture.getId();
    }

    private void textureCreationFailed(int textureWidth, int textureHeight, @Nonnull Exception exception) {
        log.log(Level.SEVERE, "Failed to create texture of width: " + textureWidth + " & height: " + textureHeight + ".", exception);
    }

    @Nonnull
    private CoreTexture2D createTexture(@Nonnull ByteBuffer imageData, int textureWidth, int textureHeight) throws Exception {
        return new CoreTexture2D(this.gl, this.bufferFactory, CoreTexture2D.ColorFormat.RGBA, textureWidth, textureHeight, imageData, this.getTextureQuality());
    }

    @Nonnull
    private CoreTexture2D.ResizeFilter getTextureQuality() {
        return this.shouldUseHighQualityTextures ? CoreTexture2D.ResizeFilter.LinearMipMapLinear : CoreTexture2D.ResizeFilter.Nearest;
    }

    private void updateAtlasTexture(int atlasTextureId, @Nullable ByteBuffer imageData) {
        this.bindAtlasTexture(atlasTextureId);
        this.getAtlasTexture(atlasTextureId).updateTextureData(imageData);
    }

    private void updateAtlasTextureSection(int atlasTextureId, @Nullable ByteBuffer imageData, int atlasSectionX, int atlasSectionY, int atlasSectionWidth, int atlasSectionHeight) {
        if (imageData == null) {
            log.severe("Attempted to update section of atlas texture (id: " + atlasTextureId + ") with null image data!");
            return;
        }
        log.fine("updateAtlasTextureSection with atlas texture id: " + atlasTextureId);
        this.bindAtlasTexture(atlasTextureId);
        this.gl.glTexSubImage2D(this.gl.GL_TEXTURE_2D(), 0, atlasSectionX, atlasSectionY, atlasSectionWidth, atlasSectionHeight, this.gl.GL_RGBA(), this.gl.GL_UNSIGNED_BYTE(), imageData);
        CheckGL.checkGLError(this.gl, "Failed to update section [x, y, w, h]: [" + atlasSectionX + ", " + atlasSectionY + ", " + atlasSectionWidth + ", " + atlasSectionHeight + "] of atlas texture with id: " + atlasTextureId + ".");
    }

    private void bindAtlasTexture(int atlasTextureId) {
        log.fine("bindAtlasTexture with atlas texture id: " + atlasTextureId);
        log.fine("bindAtlasTexture: available atlas texture ids:");
        for (int textureId : this.atlasTextures.keySet()) {
            log.fine("bindAtlasTexture: available atlas texture id: " + textureId);
        }
        this.getAtlasTexture(atlasTextureId).bind();
    }

    private CoreTexture2D getAtlasTexture(int atlasTextureId) {
        return this.atlasTextures.get(atlasTextureId);
    }

    private int createNonAtlasTextureInternal(@Nonnull ByteBuffer imageData, int width, int height) throws Exception {
        CoreTexture2D nonAtlasTexture = this.createTexture(imageData, width, height);
        this.nonAtlasTextures.put(nonAtlasTexture.getId(), nonAtlasTexture);
        return nonAtlasTexture.getId();
    }

    private void deleteNonAtlasTextureInternal(int nonAtlasTextureId) {
        this.getNonAtlasTexture(nonAtlasTextureId).dispose();
        this.nonAtlasTextures.remove(nonAtlasTextureId);
    }

    private CoreTexture2D getNonAtlasTexture(int nonAtlasTextureId) {
        return this.nonAtlasTextures.get(nonAtlasTextureId);
    }

    private void textureDeletionFailed(int textureId, Exception exception) {
        log.log(Level.WARNING, "Failed to delete texture width id: " + textureId + ".", exception);
    }

    private CoreTexture2D findTexture(int textureId) {
        if (this.atlasTextures.containsKey(textureId)) {
            return this.atlasTextures.get(textureId);
        }
        if (this.nonAtlasTextures.containsKey(textureId)) {
            return this.nonAtlasTextures.get(textureId);
        }
        throw new IllegalStateException("Cannot find texture with id: " + textureId);
    }

    private void addQuadToCurrentBatch(float x, float y, float width, float height, @Nonnull Color color1, @Nonnull Color color2, @Nonnull Color color3, @Nonnull Color color4, float textureX, float textureY, float textureWidth, float textureHeight) {
        assert (this.currentBatch != null);
        this.currentBatch.addQuad(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
    }

    private void updateCurrentBatch(int textureId) {
        if (this.shouldBeginBatch()) {
            this.beginBatch(this.getCurrentBlendMode(), textureId);
        }
    }

    @Nonnull
    private BlendMode getCurrentBlendMode() {
        assert (this.currentBatch != null);
        return this.currentBatch.getBlendMode();
    }

    private boolean shouldBeginBatch() {
        assert (this.currentBatch != null);
        return !this.currentBatch.canAddQuad();
    }

    @Nonnull
    private CoreBatch createNewBatch() {
        return this.batchPool.allocate();
    }

    private void addBatch(@Nonnull CoreBatch batch) {
        this.batches.add(batch);
    }

    private void renderBatches() {
        for (CoreBatch batch : this.batches) {
            batch.render();
        }
    }

    private void beginRendering() {
        this.gl.glActiveTexture(this.gl.GL_TEXTURE0());
        this.gl.glBindSampler(0, 0);
        this.gl.glEnable(this.gl.GL_BLEND());
        this.gl.glEnable(this.gl.GL_PRIMITIVE_RESTART());
        this.gl.glPrimitiveRestartIndex(65535);
    }

    private void endRendering() {
        this.gl.glDisable(this.gl.GL_PRIMITIVE_RESTART());
        this.gl.glDisable(this.gl.GL_BLEND());
    }

    private int getTotalBatchesRendered() {
        return this.batches.size();
    }

    private boolean existsCursor(@Nonnull String filename) {
        return this.cursorCache.containsKey(filename);
    }

    @Nonnull
    private MouseCursor getCursor(@Nonnull String filename) {
        assert (this.cursorCache.containsKey(filename));
        return this.cursorCache.get(filename);
    }

    @Nullable
    private MouseCursor createCursor(String filename, int hotspotX, int hotspotY) {
        try {
            assert (this.resourceLoader != null);
            this.cursorCache.put(filename, this.mouseCursorFactory.create(filename, hotspotX, hotspotY, this.resourceLoader));
            return this.cursorCache.get(filename);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not create mouse cursor [" + filename + "]", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private BatchRenderBackend.Image createImageFromFile(@Nonnull String filename) {
        ImageLoader loader = ImageLoaderFactory.createImageLoader(filename);
        InputStream imageStream = null;
        try {
            assert (this.resourceLoader != null);
            imageStream = this.resourceLoader.getResourceAsStream(filename);
            if (imageStream != null) {
                ByteBuffer image = loader.loadAsByteBufferRGBA(imageStream);
                image.rewind();
                int width = loader.getImageWidth();
                int height = loader.getImageHeight();
                BatchRenderBackend.Image image2 = this.imageFactory.create(image, width, height);
                return image2;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not load image from file: [" + filename + "]", e);
        }
        finally {
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.imageFactory.create(null, 0, 0);
    }
}

