/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.batch;

import de.lessvoid.nifty.render.batch.BatchRenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jglfont.JGLFont;
import org.jglfont.JGLFontFactory;

public class BatchRenderFont
implements RenderFont {
    private final BatchRenderDevice batchRenderDevice;
    private final JGLFont font;

    public BatchRenderFont(BatchRenderDevice batchRenderDevice, @Nonnull String name, @Nonnull JGLFontFactory factory, @Nonnull NiftyResourceLoader resourceLoader) throws IOException {
        this.batchRenderDevice = batchRenderDevice;
        this.font = factory.loadFont(resourceLoader.getResourceAsStream(name), name);
    }

    @Override
    public int getHeight() {
        return this.font.getHeight();
    }

    @Override
    public int getWidth(@Nonnull String text) {
        return this.font.getStringWidth(text);
    }

    @Override
    public int getWidth(@Nonnull String text, float size) {
        return this.font.getStringWidth(text, size);
    }

    @Override
    public int getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        return this.font.getCharacterWidth(currentCharacter, nextCharacter, size);
    }

    @Override
    public void dispose() {
        this.batchRenderDevice.disposeFont(this);
    }

    public JGLFont getBitmapFont() {
        return this.font;
    }
}

