/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyImageManager;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.ScalingRenderDevice;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyRenderEngineImpl
implements NiftyRenderEngine {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyRenderEngineImpl.class.getName());
    @Nonnull
    private final RenderDevice renderDevice;
    private int displayWidth;
    private int displayHeight;
    private int nativeDisplayWidth;
    private int nativeDisplayHeight;
    private boolean autoScaling = false;
    @Nullable
    private Float autoScalingScaleX = null;
    @Nullable
    private Float autoScalingScaleY = null;
    private float autoScalingOffsetX = 0.0f;
    private float autoScalingOffsetY = 0.0f;
    private float globalPosX = 0.0f;
    private float globalPosY = 0.0f;
    private float currentX = 0.0f;
    private float currentY = 0.0f;
    @Nullable
    private RenderFont font;
    @Nonnull
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private boolean colorChanged = false;
    private boolean colorAlphaChanged = false;
    private float imageScale = 1.0f;
    private float textScale = 1.0f;
    @Nonnull
    private final Map<String, RenderFont> fontCache = new HashMap<String, RenderFont>();
    @Nonnull
    private final Deque<SavedRenderState> stack = new ArrayDeque<SavedRenderState>(20);
    @Nonnull
    private final Color whiteColor = new Color("#ffff");
    private boolean clipEnabled;
    @Nonnull
    private final Clip clip = new Clip(0, 0, 0, 0);
    private final Clip absoluteClip = new Clip(0, 0, 0, 0);
    @Nonnull
    private BlendMode blendMode = BlendMode.BLEND;
    @Nonnull
    private final NiftyImageManager imageManager;
    private boolean absoluteClipEnabled;

    public NiftyRenderEngineImpl(@Nonnull RenderDevice renderDeviceParam) {
        this.renderDevice = new ScalingRenderDevice(this, renderDeviceParam);
        this.displayWidth = this.renderDevice.getWidth();
        this.displayHeight = this.renderDevice.getHeight();
        this.nativeDisplayWidth = this.renderDevice.getWidth();
        this.nativeDisplayHeight = this.renderDevice.getHeight();
        this.imageManager = new NiftyImageManager(renderDeviceParam);
        this.absoluteClip.x0 = 0;
        this.absoluteClip.y0 = 0;
        this.absoluteClip.x1 = this.displayWidth;
        this.absoluteClip.y1 = this.displayHeight;
    }

    @Override
    public int getWidth() {
        return this.displayWidth;
    }

    @Override
    public int getHeight() {
        return this.displayHeight;
    }

    @Override
    public void beginFrame() {
        this.renderDevice.beginFrame();
        this.colorChanged = false;
    }

    @Override
    public void endFrame() {
        this.renderDevice.endFrame();
    }

    @Override
    public void clear() {
        this.renderDevice.clear();
    }

    @Override
    @Nullable
    public NiftyImage createImage(@Nonnull Screen screen, @Nonnull String filename, boolean filterLinear) {
        RenderImage image = this.imageManager.registerImage(filename, filterLinear, screen);
        if (image == null) {
            return null;
        }
        return new NiftyImage(this, image);
    }

    @Override
    @Nullable
    public RenderFont createFont(@Nonnull String filename) {
        if (this.fontCache.containsKey(filename)) {
            return this.fontCache.get(filename);
        }
        NiftyStopwatch.start();
        RenderFont newFont = this.renderDevice.createFont(filename);
        this.fontCache.put(filename, newFont);
        NiftyStopwatch.stop("RenderDevice.createFont(" + filename + ")");
        return newFont;
    }

    @Override
    @Nonnull
    public String getFontname(@Nonnull RenderFont font) {
        for (Map.Entry<String, RenderFont> entry : this.fontCache.entrySet()) {
            if (!entry.getValue().equals(font)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Font not found in storage of this render engine. Maybe it was load by another engine?");
    }

    @Override
    public void renderQuad(int x, int y, int width, int height) {
        this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, this.color);
    }

    @Override
    public void renderQuad(int x, int y, int width, int height, @Nonnull Color topLeft, @Nonnull Color topRight, @Nonnull Color bottomRight, @Nonnull Color bottomLeft) {
        if (this.isColorAlphaChanged()) {
            Color a = new Color(topLeft, this.color.getAlpha());
            Color b = new Color(topRight, this.color.getAlpha());
            Color c = new Color(bottomRight, this.color.getAlpha());
            Color d = new Color(bottomLeft, this.color.getAlpha());
            this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, a, b, c, d);
        } else {
            this.renderDevice.renderQuad(x + this.getX(), y + this.getY(), width, height, topLeft, topRight, bottomRight, bottomLeft);
        }
    }

    @Override
    public void renderImage(@Nonnull NiftyImage image, int x, int y, int width, int height) {
        Color c = image.getColor();
        if (c == null) {
            c = this.whiteColor;
        }
        if (this.isColorAlphaChanged()) {
            float alpha = this.color.getAlpha();
            c = new Color(c, alpha);
        }
        image.render(x + this.getX(), y + this.getY(), width, height, c, this.imageScale);
    }

    @Override
    public void renderText(@Nonnull String text, int x, int y, int selectionStart, int selectionEnd, @Nonnull Color textSelectionColor) {
        if (this.isSelection(selectionStart, selectionEnd)) {
            this.renderSelectionText(text, x + this.getX(), y + this.getY(), this.color, textSelectionColor, this.textScale, this.textScale, selectionStart, selectionEnd);
        } else {
            if (this.font == null) {
                log.warning("missing font in renderText! could it be that you're using <text> elements without a font or style attribute? in case you've replaced <label> with <text> you're probably missing style='nifty-label' :)");
                return;
            }
            this.renderDevice.renderFont(this.font, text, x + this.getX(), y + this.getY(), this.color, this.textScale, this.textScale);
        }
    }

    protected void renderSelectionText(@Nonnull String text, int x, int y, @Nonnull Color textColor, @Nonnull Color textSelectionColor, float textSizeX, float textSizeY, int selectionStartParam, int selectionEndParam) {
        int selectionStart = selectionStartParam;
        int selectionEnd = selectionEndParam;
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        if (this.font == null) {
            return;
        }
        if (this.isEverythingSelected(text, selectionStart, selectionEnd)) {
            this.renderDevice.renderFont(this.font, text, x, y, textSelectionColor, textSizeX, textSizeY);
        } else if (this.isSelectionAtBeginning(selectionStart)) {
            String selectedString = text.substring(selectionStart, selectionEnd);
            String unselectedString = text.substring(selectionEnd);
            this.renderDevice.renderFont(this.font, selectedString, x, y, textSelectionColor, textSizeX, textSizeY);
            this.renderDevice.renderFont(this.font, unselectedString, x + this.font.getWidth(selectedString), y, textColor, textSizeX, textSizeY);
        } else if (this.isSelectionAtEnd(text, selectionEnd)) {
            String unselectedString = text.substring(0, selectionStart);
            String selectedString = text.substring(selectionStart, selectionEnd);
            this.renderDevice.renderFont(this.font, unselectedString, x, y, textColor, textSizeX, textSizeY);
            this.renderDevice.renderFont(this.font, selectedString, x + this.font.getWidth(unselectedString), y, textSelectionColor, textSizeX, textSizeY);
        } else {
            String unselectedString1 = text.substring(0, selectionStart);
            String selectedString = text.substring(selectionStart, selectionEnd);
            String unselectedString2 = text.substring(selectionEnd, text.length());
            this.renderDevice.renderFont(this.font, unselectedString1, x, y, textColor, textSizeX, textSizeY);
            int unselectedString1Len = this.font.getWidth(unselectedString1);
            this.renderDevice.renderFont(this.font, selectedString, x + unselectedString1Len, y, textSelectionColor, textSizeX, textSizeY);
            int selectedStringLen = this.font.getWidth(selectedString);
            this.renderDevice.renderFont(this.font, unselectedString2, x + unselectedString1Len + selectedStringLen, y, textColor, textSizeX, textSizeY);
        }
    }

    private boolean isSelectionAtEnd(@Nonnull String text, int selectionEnd) {
        return selectionEnd == text.length();
    }

    private boolean isSelectionAtBeginning(int selectionStart) {
        return selectionStart == 0;
    }

    private boolean isEverythingSelected(@Nonnull String text, int selectionStart, int selectionEnd) {
        return this.isSelectionAtBeginning(selectionStart) && this.isSelectionAtEnd(text, selectionEnd);
    }

    @Override
    public void setFont(@Nullable RenderFont newFont) {
        this.font = newFont;
    }

    @Override
    @Nullable
    public RenderFont getFont() {
        return this.font;
    }

    @Override
    public void setColor(@Nonnull Color colorParam) {
        this.color.setRed(colorParam.getRed());
        this.color.setGreen(colorParam.getGreen());
        this.color.setBlue(colorParam.getBlue());
        this.color.setAlpha(colorParam.getAlpha());
        this.colorChanged = true;
        this.colorAlphaChanged = true;
    }

    @Override
    public void setColorAlpha(float newColorAlpha) {
        this.color.setAlpha(newColorAlpha);
        this.colorAlphaChanged = true;
    }

    @Override
    public void setColorIgnoreAlpha(@Nonnull Color newColor) {
        this.color.setRed(newColor.getRed());
        this.color.setGreen(newColor.getGreen());
        this.color.setBlue(newColor.getBlue());
        this.colorChanged = true;
        if (this.colorAlphaChanged && this.color.getAlpha() > newColor.getAlpha()) {
            this.color.setAlpha(newColor.getAlpha());
            this.colorAlphaChanged = true;
        }
    }

    @Override
    public boolean isColorChanged() {
        return this.colorChanged;
    }

    @Override
    public boolean isColorAlphaChanged() {
        return this.colorAlphaChanged;
    }

    @Override
    public void moveTo(float xParam, float yParam) {
        this.currentX = xParam;
        this.currentY = yParam;
    }

    @Override
    public void moveToRelative(float xParam, float yParam) {
        this.currentX += xParam;
        this.currentY += yParam;
    }

    @Override
    public void setAbsoluteClip(int x0, int y0, int x1, int y1) {
        this.absoluteClipEnabled = true;
        this.absoluteClip.x0 = x0;
        this.absoluteClip.y0 = y0;
        this.absoluteClip.x1 = x1;
        this.absoluteClip.y1 = y1;
    }

    @Override
    public void applyAbsoluteClip() {
        if (this.absoluteClipEnabled) {
            this.updateClip(true, this.absoluteClip.x0, this.absoluteClip.y0, this.absoluteClip.x1, this.absoluteClip.y1);
        }
    }

    @Override
    public void disableAbsoluteClip() {
        this.absoluteClipEnabled = false;
    }

    @Override
    public void enableClip(int cx0, int cy0, int cx1, int cy1) {
        int x0 = cx0 + this.getX();
        int y0 = cy0 + this.getY();
        int x1 = cx1 + this.getX();
        int y1 = cy1 + this.getY();
        if (this.clipEnabled) {
            if (this.isOutsideClippingRectangle(x0, y0, x1, y1)) {
                return;
            }
            if (this.isInsideClippingRectangle(x0, y0, x1, y1)) {
                this.updateClip(true, x0, y0, x1, y1);
                return;
            }
            int newX0 = Math.max(x0, this.clip.x0);
            int newY0 = Math.max(y0, this.clip.y0);
            int newX1 = Math.min(x1, this.clip.x1);
            int newY1 = Math.min(y1, this.clip.y1);
            this.updateClip(true, newX0, newY0, newX1, newY1);
            return;
        }
        this.updateClip(true, x0, y0, x1, y1);
    }

    @Override
    public void disableClip() {
        this.updateClip(false, 0, 0, 0, 0);
    }

    void updateClip(boolean enabled, int x0, int y0, int x1, int y1) {
        this.clipEnabled = enabled;
        this.clip.init(x0, y0, x1, y1);
        if (!this.clipEnabled) {
            this.renderDevice.disableClip();
        } else {
            this.clip.apply();
        }
    }

    @Override
    public void setRenderTextSize(float size) {
        this.textScale = size;
    }

    @Override
    public void setImageScale(float scale) {
        this.imageScale = scale;
    }

    @Override
    public void setGlobalPosition(float xPos, float yPos) {
        this.globalPosX = xPos;
        this.globalPosY = yPos;
    }

    @Override
    public void displayResolutionChanged() {
        if (!this.autoScaling) {
            this.displayWidth = this.renderDevice.getWidth();
            this.displayHeight = this.renderDevice.getHeight();
        }
        this.nativeDisplayWidth = this.renderDevice.getWidth();
        this.nativeDisplayHeight = this.renderDevice.getHeight();
    }

    private int getX() {
        return (int)(this.globalPosX + this.currentX);
    }

    private int getY() {
        return (int)(this.globalPosY + this.currentY);
    }

    private boolean isSelection(int selectionStart, int selectionEnd) {
        return selectionStart != -1 || selectionEnd != -1;
    }

    @Override
    public void saveStates() {
        SavedRenderState savedRenderState = new SavedRenderState();
        savedRenderState.save();
        this.stack.push(savedRenderState);
    }

    @Override
    public void restoreStates() {
        SavedRenderState restored = this.stack.pop();
        restored.restore();
    }

    @Override
    public void setBlendMode(@Nonnull BlendMode blendModeParam) {
        this.blendMode = blendModeParam;
        this.renderDevice.setBlendMode(blendModeParam);
    }

    @Override
    @Nonnull
    public RenderDevice getRenderDevice() {
        return this.renderDevice;
    }

    @Override
    public void disposeImage(@Nonnull RenderImage image) {
        this.imageManager.unregisterImage(image);
    }

    @Override
    @Nonnull
    public RenderImage reload(@Nonnull RenderImage image) {
        return this.imageManager.reload(image);
    }

    @Override
    public int getNativeWidth() {
        return this.nativeDisplayWidth;
    }

    @Override
    public int getNativeHeight() {
        return this.nativeDisplayHeight;
    }

    @Override
    public int convertToNativeX(int x) {
        return (int)Math.floor((float)x * this.getScaleX() + this.autoScalingOffsetX);
    }

    @Override
    public int convertToNativeY(int y) {
        return (int)Math.floor((float)y * this.getScaleY() + this.autoScalingOffsetY);
    }

    @Override
    public int convertToNativeWidth(int x) {
        return (int)Math.ceil((float)x * this.getScaleX());
    }

    @Override
    public int convertToNativeHeight(int y) {
        return (int)Math.ceil((float)y * this.getScaleY());
    }

    @Override
    public int convertFromNativeX(int x) {
        return (int)Math.ceil(((float)x - this.autoScalingOffsetX) * (1.0f / this.getScaleX()));
    }

    @Override
    public int convertFromNativeY(int y) {
        return (int)Math.ceil(((float)y - this.autoScalingOffsetY) * (1.0f / this.getScaleY()));
    }

    @Override
    public float convertToNativeTextSizeX(float size) {
        return size * this.getScaleX();
    }

    @Override
    public float convertToNativeTextSizeY(float size) {
        return size * this.getScaleY();
    }

    private float getScaleX() {
        if (this.autoScalingScaleX != null) {
            return this.autoScalingScaleX.floatValue();
        }
        return (float)this.getNativeWidth() / (float)this.getWidth();
    }

    private float getScaleY() {
        if (this.autoScalingScaleY != null) {
            return this.autoScalingScaleY.floatValue();
        }
        return (float)this.getNativeHeight() / (float)this.getHeight();
    }

    @Override
    public void enableAutoScaling(int baseResolutionX, int baseResolutionY) {
        this.autoScaling = true;
        this.displayWidth = baseResolutionX;
        this.displayHeight = baseResolutionY;
        this.autoScalingScaleX = null;
        this.autoScalingScaleY = null;
        this.autoScalingOffsetX = 0.0f;
        this.autoScalingOffsetY = 0.0f;
    }

    @Override
    public void enableAutoScaling(int baseResolutionX, int baseResolutionY, float scaleX, float scaleY) {
        this.autoScaling = true;
        this.displayWidth = baseResolutionX;
        this.displayHeight = baseResolutionY;
        this.autoScalingScaleX = Float.valueOf((float)this.getNativeWidth() / (float)this.getWidth() * scaleX);
        this.autoScalingScaleY = Float.valueOf((float)this.getNativeHeight() / (float)this.getHeight() * scaleY);
        this.autoScalingOffsetX = (float)(this.getNativeWidth() / 2) - (float)(this.getNativeWidth() / 2) * scaleX;
        this.autoScalingOffsetY = (float)(this.getNativeHeight() / 2) - (float)(this.getNativeHeight() / 2) * scaleY;
    }

    @Override
    public void disableAutoScaling() {
        this.autoScaling = false;
        this.displayWidth = this.nativeDisplayWidth;
        this.displayHeight = this.nativeDisplayHeight;
        this.autoScalingScaleX = null;
        this.autoScalingScaleY = null;
        this.autoScalingOffsetX = 0.0f;
        this.autoScalingOffsetY = 0.0f;
    }

    @Override
    public void screenStarted(@Nonnull Screen screen) {
        this.imageManager.uploadScreenImages(screen);
    }

    @Override
    public void screenEnded(@Nonnull Screen screen) {
        this.imageManager.unloadScreenImages(screen);
    }

    @Override
    public void screensClear(@Nonnull Collection<Screen> screens) {
        for (Screen screen : screens) {
            this.imageManager.unloadScreenImages(screen);
            this.imageManager.screenRemoved(screen);
        }
    }

    @Override
    public void screenAdded(@Nonnull Screen screen) {
        this.imageManager.screenAdded(screen);
    }

    @Override
    public void screenRemoved(@Nonnull Screen screen) {
        this.imageManager.screenRemoved(screen);
    }

    private boolean isOutsideClippingRectangle(int x0, int y0, int x1, int y1) {
        if (x0 > this.clip.x1) {
            return true;
        }
        if (x1 < this.clip.x0) {
            return true;
        }
        if (y0 > this.clip.y1) {
            return true;
        }
        return y1 < this.clip.y0;
    }

    private boolean isInsideClippingRectangle(int x0, int y0, int x1, int y1) {
        return x0 >= this.clip.x0 && x0 <= this.clip.x1 && x1 >= this.clip.x0 && x1 <= this.clip.x1 && y0 >= this.clip.y0 && y0 <= this.clip.y1 && y1 >= this.clip.y0 && y1 <= this.clip.y1;
    }

    public class Clip {
        private int x0;
        private int y0;
        private int x1;
        private int y1;

        public Clip(int x0, int y0, int x1, int y1) {
            this.init(x0, y0, x1, y1);
        }

        public void init(int x0, int y0, int x1, int y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        public void apply() {
            NiftyRenderEngineImpl.this.renderDevice.enableClip(this.x0, this.y0, this.x1, this.y1);
        }
    }

    private class SavedRenderState {
        private float x;
        private float y;
        private float colorR;
        private float colorG;
        private float colorB;
        private boolean colorChanged;
        private float colorAlpha;
        private boolean colorAlphaChanged;
        @Nullable
        private RenderFont font;
        private float textSize;
        private float imageScale;
        private boolean clipEnabled;
        @Nonnull
        private final Clip clip;
        private BlendMode blendMode;

        public SavedRenderState() {
            this.clip = new Clip(0, 0, 0, 0);
        }

        public void save() {
            this.savePosition();
            this.saveColor();
            this.saveColorAlpha();
            this.saveTextSize();
            this.saveImageSize();
            this.saveFont();
            this.saveClipEnabled();
            this.saveBlendMode();
        }

        public void restore() {
            this.restorePosition();
            this.restoreColor();
            this.restoreAlpha();
            this.restoreFont();
            this.restoreTextSize();
            this.restoreImageScale();
            this.restoreClip();
            this.restoreBlend();
        }

        private void saveBlendMode() {
            this.blendMode = NiftyRenderEngineImpl.this.blendMode;
        }

        private void saveClipEnabled() {
            this.clipEnabled = NiftyRenderEngineImpl.this.clipEnabled;
            this.clip.init(NiftyRenderEngineImpl.this.clip.x0, NiftyRenderEngineImpl.this.clip.y0, NiftyRenderEngineImpl.this.clip.x1, NiftyRenderEngineImpl.this.clip.y1);
        }

        private void saveFont() {
            this.font = NiftyRenderEngineImpl.this.font;
        }

        private void saveImageSize() {
            this.imageScale = NiftyRenderEngineImpl.this.imageScale;
        }

        private void saveTextSize() {
            this.textSize = NiftyRenderEngineImpl.this.textScale;
        }

        private void saveColorAlpha() {
            this.colorAlpha = NiftyRenderEngineImpl.this.color.getAlpha();
            this.colorAlphaChanged = NiftyRenderEngineImpl.this.colorAlphaChanged;
        }

        private void saveColor() {
            this.colorR = NiftyRenderEngineImpl.this.color.getRed();
            this.colorG = NiftyRenderEngineImpl.this.color.getGreen();
            this.colorB = NiftyRenderEngineImpl.this.color.getBlue();
            this.colorChanged = NiftyRenderEngineImpl.this.colorChanged;
        }

        private void savePosition() {
            this.x = NiftyRenderEngineImpl.this.currentX;
            this.y = NiftyRenderEngineImpl.this.currentY;
        }

        private void restoreBlend() {
            NiftyRenderEngineImpl.this.setBlendMode(this.blendMode);
        }

        private void restoreClip() {
            NiftyRenderEngineImpl.this.updateClip(this.clipEnabled, this.clip.x0, this.clip.y0, this.clip.x1, this.clip.y1);
        }

        private void restoreImageScale() {
            NiftyRenderEngineImpl.this.imageScale = this.imageScale;
        }

        private void restoreTextSize() {
            NiftyRenderEngineImpl.this.textScale = this.textSize;
        }

        private void restoreFont() {
            NiftyRenderEngineImpl.this.font = this.font;
        }

        private void restoreAlpha() {
            NiftyRenderEngineImpl.this.color.setAlpha(this.colorAlpha);
            NiftyRenderEngineImpl.this.colorAlphaChanged = this.colorAlphaChanged;
        }

        private void restoreColor() {
            NiftyRenderEngineImpl.this.color.setRed(this.colorR);
            NiftyRenderEngineImpl.this.color.setGreen(this.colorG);
            NiftyRenderEngineImpl.this.color.setBlue(this.colorB);
            NiftyRenderEngineImpl.this.colorChanged = this.colorChanged;
        }

        private void restorePosition() {
            NiftyRenderEngineImpl.this.currentX = this.x;
            NiftyRenderEngineImpl.this.currentY = this.y;
        }
    }
}

